/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.grpc.test;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.grpc.test.Kind;
import org.apache.avro.grpc.test.MD5;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class TestRecord
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 945304076389679512L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"TestRecord\",\"namespace\":\"org.apache.avro.grpc.test\",\"fields\":[{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\",\"order\":\"ignore\"}},{\"name\":\"kind\",\"type\":{\"type\":\"enum\",\"name\":\"Kind\",\"symbols\":[\"FOO\",\"BAR\",\"BAZ\"],\"order\":\"descending\"}},{\"name\":\"hash\",\"type\":{\"type\":\"fixed\",\"name\":\"MD5\",\"size\":4}},{\"name\":\"nullableHash\",\"type\":[\"MD5\",\"null\"],\"aliases\":[\"hash\"]},{\"name\":\"arrayOfLongs\",\"type\":{\"type\":\"array\",\"items\":\"long\"}}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<TestRecord> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<TestRecord> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public String name;
    @Deprecated
    public Kind kind;
    @Deprecated
    public MD5 hash;
    @Deprecated
    public MD5 nullableHash;
    @Deprecated
    public List<Long> arrayOfLongs;
    private static final DatumWriter<TestRecord> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<TestRecord> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<TestRecord> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<TestRecord> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<TestRecord> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static TestRecord fromByteBuffer(ByteBuffer b) throws IOException {
        return (TestRecord)((Object)DECODER.decode(b));
    }

    public TestRecord() {
    }

    public TestRecord(String name, Kind kind, MD5 hash, MD5 nullableHash, List<Long> arrayOfLongs) {
        this.name = name;
        this.kind = kind;
        this.hash = hash;
        this.nullableHash = nullableHash;
        this.arrayOfLongs = arrayOfLongs;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.name;
            }
            case 1: {
                return this.kind;
            }
            case 2: {
                return this.hash;
            }
            case 3: {
                return this.nullableHash;
            }
            case 4: {
                return this.arrayOfLongs;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.name = (String)value$;
                break;
            }
            case 1: {
                this.kind = (Kind)((Object)value$);
                break;
            }
            case 2: {
                this.hash = (MD5)((Object)value$);
                break;
            }
            case 3: {
                this.nullableHash = (MD5)((Object)value$);
                break;
            }
            case 4: {
                this.arrayOfLongs = (List)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind value) {
        this.kind = value;
    }

    public MD5 getHash() {
        return this.hash;
    }

    public void setHash(MD5 value) {
        this.hash = value;
    }

    public MD5 getNullableHash() {
        return this.nullableHash;
    }

    public void setNullableHash(MD5 value) {
        this.nullableHash = value;
    }

    public List<Long> getArrayOfLongs() {
        return this.arrayOfLongs;
    }

    public void setArrayOfLongs(List<Long> value) {
        this.arrayOfLongs = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(TestRecord other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeString(this.name);
        out.writeEnum(this.kind.ordinal());
        out.writeFixed(this.hash.bytes(), 0, 4);
        if (this.nullableHash == null) {
            out.writeIndex(1);
            out.writeNull();
        } else {
            out.writeIndex(0);
            out.writeFixed(this.nullableHash.bytes(), 0, 4);
        }
        long size0 = this.arrayOfLongs.size();
        out.writeArrayStart();
        out.setItemCount(size0);
        long actualSize0 = 0L;
        for (Long e0 : this.arrayOfLongs) {
            ++actualSize0;
            out.startItem();
            out.writeLong(e0.longValue());
        }
        out.writeArrayEnd();
        if (actualSize0 != size0) {
            throw new ConcurrentModificationException("Array-size written was " + size0 + ", but element count was " + actualSize0 + ".");
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            GenericData.Array ga0;
            this.name = in.readString();
            this.kind = Kind.values()[in.readEnum()];
            if (this.hash == null) {
                this.hash = new MD5();
            }
            in.readFixed(this.hash.bytes(), 0, 4);
            if (in.readIndex() != 0) {
                in.readNull();
                this.nullableHash = null;
            } else {
                if (this.nullableHash == null) {
                    this.nullableHash = new MD5();
                }
                in.readFixed(this.nullableHash.bytes(), 0, 4);
            }
            long size0 = in.readArrayStart();
            GenericData.Array a0 = this.arrayOfLongs;
            if (a0 == null) {
                this.arrayOfLongs = a0 = new GenericData.Array((int)size0, SCHEMA$.getField("arrayOfLongs").schema());
            } else {
                a0.clear();
            }
            GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
            while (0L < size0) {
                while (size0 != 0L) {
                    Long e0 = ga0 != null ? (Long)ga0.peek() : null;
                    e0 = in.readLong();
                    a0.add(e0);
                    --size0;
                }
                size0 = in.arrayNext();
            }
        } else {
            block9: for (int i = 0; i < 5; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.name = in.readString();
                        continue block9;
                    }
                    case 1: {
                        this.kind = Kind.values()[in.readEnum()];
                        continue block9;
                    }
                    case 2: {
                        if (this.hash == null) {
                            this.hash = new MD5();
                        }
                        in.readFixed(this.hash.bytes(), 0, 4);
                        continue block9;
                    }
                    case 3: {
                        if (in.readIndex() != 0) {
                            in.readNull();
                            this.nullableHash = null;
                            continue block9;
                        }
                        if (this.nullableHash == null) {
                            this.nullableHash = new MD5();
                        }
                        in.readFixed(this.nullableHash.bytes(), 0, 4);
                        continue block9;
                    }
                    case 4: {
                        GenericData.Array ga0;
                        long size0 = in.readArrayStart();
                        GenericData.Array a0 = this.arrayOfLongs;
                        if (a0 == null) {
                            this.arrayOfLongs = a0 = new GenericData.Array((int)size0, SCHEMA$.getField("arrayOfLongs").schema());
                        } else {
                            a0.clear();
                        }
                        GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                        while (0L < size0) {
                            while (size0 != 0L) {
                                Long e0 = ga0 != null ? (Long)ga0.peek() : null;
                                e0 = in.readLong();
                                a0.add(e0);
                                --size0;
                            }
                            size0 = in.arrayNext();
                        }
                        continue block9;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<TestRecord>
    implements RecordBuilder<TestRecord> {
        private String name;
        private Kind kind;
        private MD5 hash;
        private MD5 nullableHash;
        private List<Long> arrayOfLongs;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.name);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.kind))) {
                this.kind = (Kind)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.kind));
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.hash))) {
                this.hash = (MD5)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.hash));
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.nullableHash))) {
                this.nullableHash = (MD5)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.nullableHash));
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], other.arrayOfLongs)) {
                this.arrayOfLongs = (List)this.data().deepCopy(this.fields()[4].schema(), other.arrayOfLongs);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
        }

        private Builder(TestRecord other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.name);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)((Object)other.kind))) {
                this.kind = (Kind)((Object)this.data().deepCopy(this.fields()[1].schema(), (Object)other.kind));
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.hash))) {
                this.hash = (MD5)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.hash));
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.nullableHash))) {
                this.nullableHash = (MD5)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.nullableHash));
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], other.arrayOfLongs)) {
                this.arrayOfLongs = (List)this.data().deepCopy(this.fields()[4].schema(), other.arrayOfLongs);
                this.fieldSetFlags()[4] = true;
            }
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String value) {
            this.validate(this.fields()[0], value);
            this.name = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasName() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearName() {
            this.name = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Kind getKind() {
            return this.kind;
        }

        public Builder setKind(Kind value) {
            this.validate(this.fields()[1], (Object)value);
            this.kind = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasKind() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearKind() {
            this.kind = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public MD5 getHash() {
            return this.hash;
        }

        public Builder setHash(MD5 value) {
            this.validate(this.fields()[2], (Object)value);
            this.hash = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasHash() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearHash() {
            this.hash = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public MD5 getNullableHash() {
            return this.nullableHash;
        }

        public Builder setNullableHash(MD5 value) {
            this.validate(this.fields()[3], (Object)value);
            this.nullableHash = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasNullableHash() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearNullableHash() {
            this.nullableHash = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public List<Long> getArrayOfLongs() {
            return this.arrayOfLongs;
        }

        public Builder setArrayOfLongs(List<Long> value) {
            this.validate(this.fields()[4], value);
            this.arrayOfLongs = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasArrayOfLongs() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearArrayOfLongs() {
            this.arrayOfLongs = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public TestRecord build() {
            try {
                TestRecord record = new TestRecord();
                record.name = this.fieldSetFlags()[0] ? this.name : (String)this.defaultValue(this.fields()[0]);
                record.kind = this.fieldSetFlags()[1] ? this.kind : (Kind)((Object)this.defaultValue(this.fields()[1]));
                record.hash = this.fieldSetFlags()[2] ? this.hash : (MD5)((Object)this.defaultValue(this.fields()[2]));
                record.nullableHash = this.fieldSetFlags()[3] ? this.nullableHash : (MD5)((Object)this.defaultValue(this.fields()[3]));
                record.arrayOfLongs = this.fieldSetFlags()[4] ? this.arrayOfLongs : (List)this.defaultValue(this.fields()[4]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

