/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.grpc;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.grpc.AvroGrpcUtils;
import org.apache.avro.grpc.ServiceDescriptor;
import org.apache.avro.ipc.CallFuture;
import org.apache.avro.ipc.Callback;

public abstract class AvroGrpcClient {
    private AvroGrpcClient() {
    }

    public static <T> T create(Channel channel, Class<T> iface) {
        return AvroGrpcClient.create(channel, iface, CallOptions.DEFAULT);
    }

    public static <T> T create(Channel channel, Class<T> iface, CallOptions callOptions) {
        Protocol protocol = AvroGrpcUtils.getProtocol(iface);
        ServiceDescriptor serviceDescriptor = ServiceDescriptor.create(iface);
        ServiceInvocationHandler proxyHandler = new ServiceInvocationHandler(channel, callOptions, protocol, serviceDescriptor);
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)proxyHandler);
    }

    private static class ServiceInvocationHandler
    implements InvocationHandler {
        private final Channel channel;
        private final CallOptions callOptions;
        private final Protocol protocol;
        private final ServiceDescriptor serviceDescriptor;

        ServiceInvocationHandler(Channel channel, CallOptions callOptions, Protocol protocol, ServiceDescriptor serviceDescriptor) {
            this.channel = channel;
            this.callOptions = callOptions;
            this.protocol = protocol;
            this.serviceDescriptor = serviceDescriptor;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.invokeUnaryMethod(method, args);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                for (Class<?> exceptionClass : method.getExceptionTypes()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    throw e;
                }
                throw new AvroRemoteException((Throwable)e);
            }
        }

        private Object invokeUnaryMethod(Method method, Object[] args) throws Exception {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length > 0 && parameterTypes[parameterTypes.length - 1] instanceof Class && Callback.class.isAssignableFrom(parameterTypes[parameterTypes.length - 1])) {
                Object[] finalArgs = Arrays.copyOf(args, args.length - 1);
                Callback callback = (Callback)args[args.length - 1];
                this.unaryRequest(method.getName(), finalArgs, callback);
                return null;
            }
            return this.unaryRequest(method.getName(), args);
        }

        private Object unaryRequest(String methodName, Object[] args) throws Exception {
            CallFuture callFuture = new CallFuture();
            this.unaryRequest(methodName, args, (Callback)callFuture);
            try {
                return callFuture.get();
            }
            catch (Exception e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw new AvroRemoteException(e.getCause());
            }
        }

        private <RespT> void unaryRequest(String methodName, Object[] args, Callback<RespT> callback) throws Exception {
            CallbackToResponseStreamObserverAdpater<RespT> observerAdpater = new CallbackToResponseStreamObserverAdpater<RespT>(callback);
            ClientCalls.asyncUnaryCall((ClientCall)this.channel.newCall(this.serviceDescriptor.getMethod(methodName, MethodDescriptor.MethodType.UNARY), this.callOptions), (Object)args, observerAdpater);
        }

        private static class CallbackToResponseStreamObserverAdpater<T>
        implements StreamObserver<Object> {
            private final Callback<T> callback;

            CallbackToResponseStreamObserverAdpater(Callback<T> callback) {
                this.callback = callback;
            }

            public void onNext(Object value) {
                if (value instanceof Throwable) {
                    this.callback.handleError((Throwable)value);
                } else {
                    this.callback.handleResult(value);
                }
            }

            public void onError(Throwable t) {
                this.callback.handleError((Throwable)new AvroRuntimeException(t));
            }

            public void onCompleted() {
            }
        }
    }
}

