/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.grpc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.grpc.AvroGrpcClient;
import org.apache.avro.grpc.AvroGrpcServer;
import org.apache.avro.grpc.test.Kind;
import org.apache.avro.grpc.test.MD5;
import org.apache.avro.grpc.test.TestError;
import org.apache.avro.grpc.test.TestRecord;
import org.apache.avro.grpc.test.TestService;
import org.apache.avro.ipc.CallFuture;
import org.apache.avro.ipc.Callback;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAvroProtocolGrpc {
    private final TestRecord record = TestRecord.newBuilder().setName("foo").setKind(Kind.FOO).setArrayOfLongs(Arrays.asList(42L, 424L, 4242L)).setHash(new MD5(new byte[]{4, 2, 4, 2})).setNullableHash(null).build();
    private final String declaredErrMsg = "Declared error";
    private final String undeclaredErrMsg = "Undeclared error";
    private final TestError declaredError = TestError.newBuilder().setMessage$("Declared error").build();
    private final RuntimeException undeclaredError = new RuntimeException("Undeclared error");
    private CountDownLatch oneWayStart;
    private CountDownLatch oneWayDone;
    private AtomicInteger oneWayCount;
    private TestService stub;
    private TestService.Callback callbackStub;
    private Server server;
    private ManagedChannel channel;

    @Before
    public void setUp() throws IOException {
        TestServiceImplBase serviceImpl = new TestServiceImplBase();
        this.setUpServerAndClient(serviceImpl);
    }

    private void setUpServerAndClient(TestService serviceImpl) throws IOException {
        if (this.server != null && !this.server.isShutdown()) {
            this.server.shutdown();
        }
        if (this.channel != null && !this.channel.isShutdown()) {
            this.channel.shutdownNow();
        }
        this.server = ServerBuilder.forPort((int)0).addService(AvroGrpcServer.createServiceDefinition(TestService.class, (Object)serviceImpl)).build();
        this.server.start();
        int port = this.server.getPort();
        this.channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)port).usePlaintext().build();
        this.stub = (TestService)AvroGrpcClient.create((Channel)this.channel, TestService.class);
        this.callbackStub = (TestService.Callback)AvroGrpcClient.create((Channel)this.channel, TestService.Callback.class);
    }

    @After
    public void cleanUp() {
        this.channel.shutdownNow();
        this.server.shutdownNow();
    }

    @Test
    public void testEchoRecord() throws Exception {
        TestRecord echoedRecord = this.stub.echo(this.record);
        Assert.assertEquals((Object)((Object)this.record), (Object)((Object)echoedRecord));
    }

    @Test
    public void testMultipleArgsAdd() throws Exception {
        int result = this.stub.add(3, 5, 2);
        Assert.assertEquals((long)10L, (long)result);
    }

    @Test
    public void testMultipleArgsConcatenate() throws Exception {
        String val1 = "foo-bar";
        Boolean val2 = true;
        long val3 = 123321L;
        int val4 = 42;
        Assert.assertEquals((Object)(val1 + val2 + val3 + val4), (Object)this.stub.concatenate(val1, val2, val3, val4));
    }

    @Test
    public void testCallbackInterface() throws Exception {
        CallFuture future = new CallFuture();
        this.callbackStub.echo(this.record, (Callback<TestRecord>)future);
        Assert.assertEquals((Object)((Object)this.record), (Object)future.get(1L, TimeUnit.SECONDS));
    }

    @Test
    public void testOneWayRpc() throws Exception {
        this.oneWayStart = new CountDownLatch(1);
        this.oneWayDone = new CountDownLatch(3);
        this.oneWayCount = new AtomicInteger();
        this.stub.ping();
        this.stub.ping();
        Assert.assertEquals((long)0L, (long)this.oneWayCount.get());
        this.oneWayStart.countDown();
        this.stub.ping();
        this.oneWayDone.await(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)this.oneWayCount.get());
    }

    @Test
    public void testDeclaredError() throws Exception {
        try {
            this.stub.error(true);
            Assert.fail((String)"Expected exception but none thrown");
        }
        catch (TestError te) {
            Assert.assertEquals((Object)"Declared error", (Object)te.getMessage$());
        }
    }

    @Test
    public void testUndeclaredError() throws Exception {
        try {
            this.stub.error(false);
            Assert.fail((String)"Expected exception but none thrown");
        }
        catch (AvroRuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Undeclared error"));
        }
    }

    @Test
    public void testNullableResponse() throws Exception {
        this.setUpServerAndClient(new TestServiceImplBase(){

            @Override
            public String concatenate(String val1, boolean val2, long val3, int val4) {
                return null;
            }
        });
        Assert.assertEquals(null, (Object)this.stub.concatenate("foo", true, 42L, 42));
    }

    @Test(expected=AvroRuntimeException.class)
    public void testGrpcConnectionError() throws Exception {
        this.channel.shutdownNow();
        this.stub.add(0, 1, 2);
    }

    @Test
    public void testRepeatedRequests() throws Exception {
        TestRecord[] echoedRecords = new TestRecord[5];
        for (int i = 0; i < 5; ++i) {
            echoedRecords[i] = this.stub.echo(this.record);
        }
        for (TestRecord result : echoedRecords) {
            Assert.assertEquals((Object)((Object)this.record), (Object)((Object)result));
        }
    }

    @Test
    public void testConcurrentClientAccess() throws Exception {
        int i;
        ExecutorService es = Executors.newCachedThreadPool();
        Future[] records = new Future[5];
        Future[] adds = new Future[5];
        for (i = 0; i < 5; ++i) {
            records[i] = es.submit(() -> this.stub.echo(this.record));
            int j = i;
            adds[i] = es.submit(() -> this.stub.add(j, 2 * j, 3 * j));
        }
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((Object)((Object)this.record), records[i].get());
            Assert.assertEquals((long)(6 * i), (long)((Integer)adds[i].get()).intValue());
        }
    }

    @Test
    public void testConcurrentChannels() throws Exception {
        int i;
        ManagedChannel otherChannel = ManagedChannelBuilder.forAddress((String)"localhost", (int)this.server.getPort()).usePlaintext().build();
        TestService otherStub = (TestService)AvroGrpcClient.create((Channel)otherChannel, TestService.class);
        Future[] adds = new Future[5];
        Future[] otherAdds = new Future[5];
        ExecutorService es = Executors.newCachedThreadPool();
        for (i = 0; i < 5; ++i) {
            int j = i;
            adds[i] = es.submit(() -> this.stub.add(j, j - 1, j - 2));
            otherAdds[i] = es.submit(() -> otherStub.add(j, j + 1, j + 2));
        }
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((long)(3 * i - 3), (long)((Integer)adds[i].get()).intValue());
            Assert.assertEquals((long)(3 * i + 3), (long)((Integer)otherAdds[i].get()).intValue());
        }
        otherChannel.shutdownNow();
    }

    private class TestServiceImplBase
    implements TestService {
        private TestServiceImplBase() {
        }

        @Override
        public TestRecord echo(TestRecord record) {
            return record;
        }

        @Override
        public int add(int arg1, int arg2, int arg3) {
            return arg1 + arg2 + arg3;
        }

        @Override
        public void error(boolean declared) throws TestError {
            if (declared) {
                throw TestAvroProtocolGrpc.this.declaredError;
            }
            throw TestAvroProtocolGrpc.this.undeclaredError;
        }

        @Override
        public void ping() {
            try {
                TestAvroProtocolGrpc.this.oneWayStart.await();
                TestAvroProtocolGrpc.this.oneWayCount.incrementAndGet();
                TestAvroProtocolGrpc.this.oneWayDone.countDown();
            }
            catch (InterruptedException e) {
                Assert.fail((String)"thread interrupted when waiting for all one-way messages");
            }
        }

        @Override
        public String concatenate(String val1, boolean val2, long val3, int val4) {
            return val1 + val2 + val3 + val4;
        }
    }
}

