/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.netty;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.apache.avro.ipc.netty.NettyTransceiver;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.socket.SocketChannel;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.junit.Assert;
import org.junit.Test;

public class NettyTransceiverWhenFailsToConnect {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void testNettyTransceiverReleasesNettyChannelOnFailingToConnect() throws Exception {
        LastChannelRememberingChannelFactory socketChannelFactory = null;
        try (ServerSocket serverSocket = new ServerSocket(0);){
            socketChannelFactory = new LastChannelRememberingChannelFactory();
            try {
                new NettyTransceiver(new InetSocketAddress(serverSocket.getLocalPort()), (ChannelFactory)socketChannelFactory, Long.valueOf(1L));
            }
            finally {
                Assert.assertFalse((String)"expected that the channel opened by the transceiver is closed", (boolean)socketChannelFactory.lastChannel.isOpen());
            }
        }
        finally {
            if (socketChannelFactory != null) {
                socketChannelFactory.releaseExternalResources();
            }
        }
    }

    class LastChannelRememberingChannelFactory
    extends NioClientSocketChannelFactory
    implements ChannelFactory {
        volatile SocketChannel lastChannel;

        LastChannelRememberingChannelFactory() {
        }

        public SocketChannel newChannel(ChannelPipeline pipeline) {
            this.lastChannel = super.newChannel(pipeline);
            return this.lastChannel;
        }
    }
}

