/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.netty;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.netty.NettyServer;
import org.apache.avro.ipc.netty.NettyTransceiver;
import org.apache.avro.ipc.netty.TestNettyServer;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.SocketChannel;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.compression.ZlibDecoder;
import org.jboss.netty.handler.codec.compression.ZlibEncoder;

public class TestNettyServerWithCompression
extends TestNettyServer {
    protected static Server initializeServer(Responder responder) {
        NioServerSocketChannelFactory channelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        return new NettyServer(responder, new InetSocketAddress(0), (ChannelFactory)channelFactory, (ChannelPipelineFactory)new CompressionChannelPipelineFactory(), null);
    }

    protected static Transceiver initializeTransceiver(int serverPort) throws IOException {
        return new NettyTransceiver(new InetSocketAddress(serverPort), (ChannelFactory)new CompressionChannelFactory(), Long.valueOf(2000L));
    }

    private static class CompressionChannelPipelineFactory
    implements ChannelPipelineFactory {
        private CompressionChannelPipelineFactory() {
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            ZlibEncoder encoder = new ZlibEncoder(6);
            pipeline.addFirst("deflater", (ChannelHandler)encoder);
            pipeline.addFirst("inflater", (ChannelHandler)new ZlibDecoder());
            return pipeline;
        }
    }

    private static class CompressionChannelFactory
    extends NioClientSocketChannelFactory {
        public CompressionChannelFactory() {
            super((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        }

        public SocketChannel newChannel(ChannelPipeline pipeline) {
            try {
                ZlibEncoder encoder = new ZlibEncoder(6);
                pipeline.addFirst("deflater", (ChannelHandler)encoder);
                pipeline.addFirst("inflater", (ChannelHandler)new ZlibDecoder());
                return super.newChannel(pipeline);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot create Compression channel", ex);
            }
        }
    }
}

