/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.netty;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.netty.NettyServer;
import org.apache.avro.ipc.netty.NettyTransceiver;
import org.apache.avro.ipc.netty.TestNettyServer;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.test.Mail;
import org.apache.avro.test.Message;
import org.junit.Assert;

public class TestNettyTransceiverWhenServerStops {
    public void testNettyTransceiverWhenServerStops() throws Exception {
        int previousSuccesses;
        TestNettyServer.MailImpl mailService = new TestNettyServer.MailImpl();
        SpecificResponder responder = new SpecificResponder(Mail.class, (Object)mailService);
        NettyServer server = new NettyServer((Responder)responder, new InetSocketAddress(0));
        server.start();
        int serverPort = server.getPort();
        NettyTransceiver transceiver = new NettyTransceiver(new InetSocketAddress(serverPort), Long.valueOf(60000L));
        Mail mail = (Mail)SpecificRequestor.getClient(Mail.class, (Transceiver)transceiver);
        AtomicInteger successes = new AtomicInteger();
        AtomicInteger failures = new AtomicInteger();
        AtomicBoolean quitOnFailure = new AtomicBoolean();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 100; ++i) {
            Thread thread = new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            mail.send(this.createMessage());
                            successes.incrementAndGet();
                        }
                    }
                    catch (Exception e) {
                        failures.incrementAndGet();
                        if (!quitOnFailure.get()) continue;
                        return;
                    }
                    break;
                }
            });
            threads.add(thread);
            thread.start();
        }
        while (successes.get() < 10000) {
            Thread.sleep(50L);
        }
        server.close();
        do {
            previousSuccesses = successes.get();
            Thread.sleep(500L);
        } while (previousSuccesses != successes.get());
        server.start();
        long now = System.currentTimeMillis();
        System.out.println("Stopping transceiver");
        quitOnFailure.set(true);
        now = System.currentTimeMillis();
        transceiver.close();
        for (Thread thread : threads) {
            thread.join();
        }
        if (System.currentTimeMillis() - now > 10000L) {
            Assert.fail((String)"Stopping NettyTransceiver and waiting for client threads to quit took too long.");
        } else {
            System.out.println("Stopping NettyTransceiver and waiting for client threads to quit took " + (System.currentTimeMillis() - now) + " ms");
        }
    }

    private Message createMessage() {
        Message msg = Message.newBuilder().setTo("wife").setFrom("husband").setBody("I love you!").build();
        return msg;
    }
}

