/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.junit.Assert;
import org.junit.Test;

public class TestProtocolParsing {
    public static Protocol getSimpleProtocol() throws IOException {
        File file = new File("../../../share/test/schemas/simple.avpr");
        return Protocol.parse((File)file);
    }

    @Test
    public void testParsing() throws IOException {
        Protocol protocol = TestProtocolParsing.getSimpleProtocol();
        Assert.assertEquals((Object)protocol.getDoc(), (Object)"Protocol used for testing.");
        Assert.assertEquals((long)6L, (long)protocol.getMessages().size());
        Assert.assertEquals((Object)"Pretend you're in a cave!", (Object)((Protocol.Message)protocol.getMessages().get("echo")).getDoc());
    }

    private static Protocol.Message parseMessage(String message) throws Exception {
        return (Protocol.Message)Protocol.parse((String)("{\"protocol\": \"org.foo.Bar\",\"types\": [],\"messages\": {" + message + "}}")).getMessages().values().iterator().next();
    }

    @Test
    public void oneWay() throws Exception {
        Protocol.Message m = TestProtocolParsing.parseMessage("\"ack\": {\"request\": [],\"response\": \"null\",\"one-way\": true}");
        Assert.assertTrue((boolean)m.isOneWay());
        m = TestProtocolParsing.parseMessage("\"ack\": {\"request\": [],\"one-way\": true}");
        Assert.assertTrue((boolean)m.isOneWay());
    }

    @Test(expected=SchemaParseException.class)
    public void oneWayResponse() throws Exception {
        TestProtocolParsing.parseMessage("\"ack\": {\"request\": [\"string\"],\"response\": \"string\",\"one-way\": true}");
    }

    @Test(expected=SchemaParseException.class)
    public void oneWayError() throws Exception {
        TestProtocolParsing.parseMessage("\"ack\": {\"request\": [\"string\"],\"errors\": [],\"one-way\": true}");
    }

    @Test
    public void testMessageFieldAliases() throws IOException {
        Protocol protocol = TestProtocolParsing.getSimpleProtocol();
        Protocol.Message msg = (Protocol.Message)protocol.getMessages().get("hello");
        Assert.assertNotNull((Object)msg);
        Schema.Field field = msg.getRequest().getField("greeting");
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)field.aliases().contains("salute"));
    }

    @Test
    public void testMessageCustomProperties() throws IOException {
        Protocol protocol = TestProtocolParsing.getSimpleProtocol();
        Protocol.Message msg = (Protocol.Message)protocol.getMessages().get("hello");
        Assert.assertNotNull((Object)msg);
        Schema.Field field = msg.getRequest().getField("greeting");
        Assert.assertNotNull((Object)field);
        Assert.assertEquals((Object)"customValue", (Object)field.getProp("customProp"));
    }
}

