/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Foo;
import org.apache.avro.Interop;
import org.apache.avro.Kind;
import org.apache.avro.MD5;
import org.apache.avro.Node;
import org.apache.avro.ipc.specific.PageView;
import org.apache.avro.ipc.specific.Person;
import org.apache.avro.ipc.specific.ProductPage;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestSpecificRecordBuilder {
    @Test
    public void testSpecificBuilder() {
        Person.Builder builder2 = Person.newBuilder().setName("James Gosling").setYearOfBirth(1955).setState("CA");
        Assert.assertTrue((boolean)builder2.hasName());
        Assert.assertEquals((Object)"James Gosling", (Object)builder2.getName());
        Assert.assertTrue((boolean)builder2.hasYearOfBirth());
        Assert.assertEquals((long)1955L, (long)builder2.getYearOfBirth());
        Assert.assertFalse((boolean)builder2.hasCountry());
        Assert.assertNull((Object)builder2.getCountry());
        Assert.assertTrue((boolean)builder2.hasState());
        Assert.assertEquals((Object)"CA", (Object)builder2.getState());
        Assert.assertFalse((boolean)builder2.hasFriends());
        Assert.assertNull(builder2.getFriends());
        Assert.assertFalse((boolean)builder2.hasLanguages());
        Assert.assertNull(builder2.getLanguages());
        Person person = builder2.build();
        Assert.assertEquals((Object)"James Gosling", (Object)person.getName());
        Assert.assertEquals((long)1955L, (long)person.getYearOfBirth());
        Assert.assertEquals((Object)"US", (Object)person.getCountry());
        Assert.assertEquals((Object)"CA", (Object)person.getState());
        Assert.assertNotNull(person.getFriends());
        Assert.assertEquals((long)0L, (long)person.getFriends().size());
        Assert.assertNotNull(person.getLanguages());
        Assert.assertEquals((long)2L, (long)person.getLanguages().size());
        Assert.assertEquals((Object)"English", (Object)person.getLanguages().get(0));
        Assert.assertEquals((Object)"Java", (Object)person.getLanguages().get(1));
        Assert.assertEquals((Object)((Object)builder2), (Object)((Object)Person.newBuilder(builder2)));
        Assert.assertEquals((Object)((Object)person), (Object)((Object)Person.newBuilder(person).build()));
        Person.Builder builderCopy = Person.newBuilder(person);
        Assert.assertEquals((Object)"James Gosling", (Object)builderCopy.getName());
        Assert.assertEquals((long)1955L, (long)builderCopy.getYearOfBirth());
        Assert.assertEquals((Object)"US", (Object)builderCopy.getCountry());
        Assert.assertEquals((Object)"CA", (Object)builderCopy.getState());
        Assert.assertNotNull(builderCopy.getFriends());
        Assert.assertEquals((long)0L, (long)builderCopy.getFriends().size());
        builderCopy.clearFriends().clearCountry();
        Assert.assertFalse((boolean)builderCopy.hasFriends());
        Assert.assertFalse((boolean)builderCopy.hasCountry());
        Assert.assertNull(builderCopy.getFriends());
        Assert.assertNull((Object)builderCopy.getCountry());
        Person person2 = builderCopy.build();
        Assert.assertNotNull(person2.getFriends());
        Assert.assertTrue((boolean)person2.getFriends().isEmpty());
    }

    @Test
    public void testUnions() {
        long datetime = 1234L;
        String product = "widget";
        PageView p = PageView.newBuilder().setDatetime(1234L).setPageContext((Object)ProductPage.newBuilder().setProduct(product).build()).build();
        Assert.assertEquals((long)datetime, (long)p.getDatetime());
        Assert.assertEquals(ProductPage.class, p.getPageContext().getClass());
        Assert.assertEquals((Object)product, (Object)((ProductPage)((Object)p.getPageContext())).getProduct());
        PageView p2 = PageView.newBuilder(p).build();
        Assert.assertEquals((long)datetime, (long)p2.getDatetime());
        Assert.assertEquals(ProductPage.class, p2.getPageContext().getClass());
        Assert.assertEquals((Object)product, (Object)((ProductPage)((Object)p2.getPageContext())).getProduct());
        Assert.assertEquals((Object)((Object)p), (Object)((Object)p2));
    }

    @Test
    public void testInterop() {
        Interop interop = Interop.newBuilder().setNullField(null).setArrayField(Arrays.asList(3.14159265, 6.022)).setBoolField(true).setBytesField(ByteBuffer.allocate(4).put(new byte[]{3, 2, 1, 0})).setDoubleField(1.41421).setEnumField(Kind.C).setFixedField(new MD5(new byte[]{0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3})).setFloatField(1.61803f).setIntField(64).setLongField(1024L).setMapField(Collections.singletonMap("Foo1", new Foo())).setRecordField(new Node()).setStringField("MyInterop").setUnionField(2.71828).build();
        Interop copy = Interop.newBuilder(interop).build();
        Assert.assertEquals((long)interop.getArrayField().size(), (long)copy.getArrayField().size());
        Assert.assertEquals(interop.getArrayField(), copy.getArrayField());
        Assert.assertEquals((Object)interop.getBoolField(), (Object)copy.getBoolField());
        Assert.assertEquals((Object)interop.getBytesField(), (Object)copy.getBytesField());
        Assert.assertEquals((double)interop.getDoubleField(), (double)copy.getDoubleField(), (double)0.001);
        Assert.assertEquals((Object)((Object)interop.getEnumField()), (Object)((Object)copy.getEnumField()));
        Assert.assertEquals((Object)((Object)interop.getFixedField()), (Object)((Object)copy.getFixedField()));
        Assert.assertEquals((double)interop.getFloatField(), (double)copy.getFloatField(), (double)0.001);
        Assert.assertEquals((long)interop.getIntField(), (long)copy.getIntField());
        Assert.assertEquals((long)interop.getLongField(), (long)copy.getLongField());
        Assert.assertEquals(interop.getMapField(), copy.getMapField());
        Assert.assertEquals((Object)((Object)interop.getRecordField()), (Object)((Object)copy.getRecordField()));
        Assert.assertEquals((Object)interop.getStringField(), (Object)copy.getStringField());
        Assert.assertEquals((Object)interop.getUnionField(), (Object)copy.getUnionField());
        Assert.assertEquals((Object)((Object)interop), (Object)((Object)copy));
    }

    @Test(expected=AvroRuntimeException.class)
    public void attemptToSetNonNullableFieldToNull() {
        Person.newBuilder().setName(null);
    }

    @Test(expected=AvroRuntimeException.class)
    public void buildWithoutSettingRequiredFields1() {
        Person.newBuilder().build();
    }

    @Test
    public void buildWithoutSettingRequiredFields2() {
        try {
            Person.newBuilder().setYearOfBirth(1900).setState("MA").build();
            Assert.fail((String)("Should have thrown " + AvroRuntimeException.class.getCanonicalName()));
        }
        catch (AvroRuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("name"));
        }
    }

    @Test
    public void buildWithoutSettingRequiredFields3() {
        try {
            Person.newBuilder().setName("Anon").setState("CA").build();
            Assert.fail((String)("Should have thrown " + AvroRuntimeException.class.getCanonicalName()));
        }
        catch (AvroRuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("year_of_birth"));
        }
    }

    @Ignore
    @Test
    public void testBuilderPerformance() {
        int count = 1000000;
        ArrayList<Person> friends = new ArrayList<Person>(0);
        ArrayList<String> languages = new ArrayList<String>(Arrays.asList("English", "Java"));
        long startTimeNanos = System.nanoTime();
        for (int ii = 0; ii < count; ++ii) {
            Person.newBuilder().setName("James Gosling").setYearOfBirth(1955).setCountry("US").setState("CA").setFriends(friends).setLanguages(languages).build();
        }
        long durationNanos = System.nanoTime() - startTimeNanos;
        double durationMillis = (double)durationNanos / 1000000.0;
        System.out.println("Built " + count + " records in " + durationMillis + "ms (" + (double)count / (durationMillis / 1000.0) + " records/sec, " + durationMillis / (double)count + "ms/record");
    }

    @Ignore
    @Test
    public void testBuilderPerformanceWithDefaultValues() {
        int count = 1000000;
        long startTimeNanos = System.nanoTime();
        for (int ii = 0; ii < count; ++ii) {
            Person.newBuilder().setName("James Gosling").setYearOfBirth(1955).setState("CA").build();
        }
        long durationNanos = System.nanoTime() - startTimeNanos;
        double durationMillis = (double)durationNanos / 1000000.0;
        System.out.println("Built " + count + " records in " + durationMillis + "ms (" + (double)count / (durationMillis / 1000.0) + " records/sec, " + durationMillis / (double)count + "ms/record");
    }

    @Ignore
    @Test
    public void testManualBuildPerformance() {
        int count = 1000000;
        ArrayList<Person> friends = new ArrayList<Person>(0);
        ArrayList<String> languages = new ArrayList<String>(Arrays.asList("English", "Java"));
        long startTimeNanos = System.nanoTime();
        for (int ii = 0; ii < count; ++ii) {
            Person person = new Person();
            person.name = "James Gosling";
            person.year_of_birth = 1955;
            person.state = "CA";
            person.country = "US";
            person.friends = friends;
            person.languages = languages;
        }
        long durationNanos = System.nanoTime() - startTimeNanos;
        double durationMillis = (double)durationNanos / 1000000.0;
        System.out.println("Built " + count + " records in " + durationMillis + "ms (" + (double)count / (durationMillis / 1000.0) + " records/sec, " + durationMillis / (double)count + "ms/record");
    }
}

