/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.ipc.HandshakeRequest;
import org.apache.avro.ipc.HandshakeResponse;
import org.apache.avro.ipc.MD5;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.ByteBufferInputStream;
import org.apache.avro.util.ByteBufferOutputStream;
import org.apache.avro.util.Utf8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Requestor {
    private static final Logger LOG = LoggerFactory.getLogger(Requestor.class);
    private static final Schema META = Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.BYTES));
    private static final GenericDatumReader<Map<CharSequence, ByteBuffer>> META_READER = new GenericDatumReader(META);
    private static final GenericDatumWriter<Map<CharSequence, ByteBuffer>> META_WRITER = new GenericDatumWriter(META);
    private Protocol local;
    private Protocol remote;
    private boolean sendLocalText;
    private Transceiver transceiver;
    protected List<RPCPlugin> rpcMetaPlugins;
    private static final EncoderFactory ENCODER_FACTORY = new EncoderFactory();
    private BinaryEncoder encoder = ENCODER_FACTORY.binaryEncoder((OutputStream)new ByteBufferOutputStream(), null);
    private static final Map<String, MD5> REMOTE_HASHES = Collections.synchronizedMap(new HashMap());
    private static final Map<MD5, Protocol> REMOTE_PROTOCOLS = Collections.synchronizedMap(new HashMap());
    private static final SpecificDatumWriter<HandshakeRequest> HANDSHAKE_WRITER = new SpecificDatumWriter(HandshakeRequest.class);
    private static final SpecificDatumReader<HandshakeResponse> HANDSHAKE_READER = new SpecificDatumReader(HandshakeResponse.class);

    public Protocol getLocal() {
        return this.local;
    }

    public Transceiver getTransceiver() {
        return this.transceiver;
    }

    protected Requestor(Protocol local, Transceiver transceiver) throws IOException {
        this.local = local;
        this.transceiver = transceiver;
        this.rpcMetaPlugins = Collections.synchronizedList(new ArrayList());
    }

    public void addRPCPlugin(RPCPlugin plugin) {
        this.rpcMetaPlugins.add(plugin);
    }

    public synchronized Object request(String messageName, Object request) throws Exception {
        Protocol.Message m;
        ByteBufferInputStream bbi;
        Transceiver t = this.getTransceiver();
        BinaryDecoder in = null;
        RPCContext context = new RPCContext();
        do {
            ByteBufferOutputStream bbo = new ByteBufferOutputStream();
            BinaryEncoder out = ENCODER_FACTORY.binaryEncoder((OutputStream)bbo, this.encoder);
            m = (Protocol.Message)this.getLocal().getMessages().get(messageName);
            if (m == null) {
                throw new AvroRuntimeException("Not a local message: " + messageName);
            }
            context.setMessage(m);
            this.writeRequest(m.getRequest(), request, (Encoder)out);
            out.flush();
            List payload = bbo.getBufferList();
            this.writeHandshake((Encoder)out);
            context.setRequestPayload(payload);
            for (RPCPlugin plugin : this.rpcMetaPlugins) {
                plugin.clientSendRequest(context);
            }
            META_WRITER.write(context.requestCallMeta(), (Encoder)out);
            out.writeString(m.getName());
            out.flush();
            bbo.append(payload);
            List requestBytes = bbo.getBufferList();
            if (m.isOneWay() && t.isConnected()) {
                t.writeBuffers(requestBytes);
                return null;
            }
            List<ByteBuffer> response = t.transceive(requestBytes);
            bbi = new ByteBufferInputStream(response);
        } while (!this.readHandshake((Decoder)(in = DecoderFactory.get().binaryDecoder((InputStream)bbi, in))));
        Protocol.Message rm = (Protocol.Message)this.remote.getMessages().get(messageName);
        if (rm == null) {
            throw new AvroRuntimeException("Not a remote message: " + messageName);
        }
        if (m.isOneWay() != rm.isOneWay() && t.isConnected()) {
            throw new AvroRuntimeException("Not both one-way messages: " + messageName);
        }
        if (m.isOneWay() && t.isConnected()) {
            return null;
        }
        context.setResponseCallMeta((Map)META_READER.read(null, (Decoder)in));
        if (!in.readBoolean()) {
            Object response = this.readResponse(rm.getResponse(), (Decoder)in);
            context.setResponse(response);
            for (RPCPlugin plugin : this.rpcMetaPlugins) {
                plugin.clientReceiveResponse(context);
            }
            return response;
        }
        Exception error = this.readError(rm.getErrors(), (Decoder)in);
        context.setError(error);
        for (RPCPlugin plugin : this.rpcMetaPlugins) {
            plugin.clientReceiveResponse(context);
        }
        throw error;
    }

    private void writeHandshake(Encoder out) throws IOException {
        if (this.getTransceiver().isConnected()) {
            return;
        }
        MD5 localHash = new MD5();
        localHash.bytes(this.local.getMD5());
        String remoteName = this.transceiver.getRemoteName();
        MD5 remoteHash = REMOTE_HASHES.get(remoteName);
        this.remote = REMOTE_PROTOCOLS.get((Object)remoteHash);
        if (remoteHash == null) {
            remoteHash = localHash;
            this.remote = this.local;
        }
        HandshakeRequest handshake = new HandshakeRequest();
        handshake.clientHash = localHash;
        handshake.serverHash = remoteHash;
        if (this.sendLocalText) {
            handshake.clientProtocol = new Utf8(this.local.toString());
        }
        RPCContext context = new RPCContext();
        context.setHandshakeRequest(handshake);
        for (RPCPlugin plugin : this.rpcMetaPlugins) {
            plugin.clientStartConnect(context);
        }
        handshake.meta = context.requestHandshakeMeta();
        HANDSHAKE_WRITER.write((Object)handshake, out);
    }

    private boolean readHandshake(Decoder in) throws IOException {
        if (this.getTransceiver().isConnected()) {
            return true;
        }
        boolean established = false;
        HandshakeResponse handshake = (HandshakeResponse)((Object)HANDSHAKE_READER.read(null, in));
        switch (handshake.match) {
            case BOTH: {
                established = true;
                this.sendLocalText = false;
                break;
            }
            case CLIENT: {
                LOG.debug("Handshake match = CLIENT");
                this.setRemote(handshake);
                established = true;
                this.sendLocalText = false;
                break;
            }
            case NONE: {
                LOG.debug("Handshake match = NONE");
                this.setRemote(handshake);
                this.sendLocalText = true;
                break;
            }
            default: {
                throw new AvroRuntimeException("Unexpected match: " + (Object)((Object)handshake.match));
            }
        }
        RPCContext context = new RPCContext();
        context.setHandshakeResponse(handshake);
        for (RPCPlugin plugin : this.rpcMetaPlugins) {
            plugin.clientFinishConnect(context);
        }
        if (established) {
            this.getTransceiver().setRemote(this.remote);
        }
        return established;
    }

    private void setRemote(HandshakeResponse handshake) {
        this.remote = Protocol.parse((String)((Object)handshake.serverProtocol).toString());
        MD5 remoteHash = handshake.serverHash;
        REMOTE_HASHES.put(this.transceiver.getRemoteName(), remoteHash);
        if (!REMOTE_PROTOCOLS.containsKey((Object)remoteHash)) {
            REMOTE_PROTOCOLS.put(remoteHash, this.remote);
        }
    }

    public synchronized Protocol getRemote() throws IOException {
        if (this.remote != null) {
            return this.remote;
        }
        MD5 remoteHash = REMOTE_HASHES.get(this.transceiver.getRemoteName());
        this.remote = REMOTE_PROTOCOLS.get((Object)remoteHash);
        if (this.remote != null) {
            return this.remote;
        }
        ByteBufferOutputStream bbo = new ByteBufferOutputStream();
        BinaryEncoder out = ENCODER_FACTORY.directBinaryEncoder((OutputStream)bbo, null);
        this.writeHandshake((Encoder)out);
        out.writeInt(0);
        out.writeString("");
        List<ByteBuffer> response = this.getTransceiver().transceive(bbo.getBufferList());
        ByteBufferInputStream bbi = new ByteBufferInputStream(response);
        BinaryDecoder in = DecoderFactory.get().binaryDecoder((InputStream)bbi, null);
        this.readHandshake((Decoder)in);
        return this.remote;
    }

    public abstract void writeRequest(Schema var1, Object var2, Encoder var3) throws IOException;

    public abstract Object readResponse(Schema var1, Decoder var2) throws IOException;

    public abstract Exception readError(Schema var1, Decoder var2) throws IOException;
}

