/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Random;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.SimpleException;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.SocketServer;
import org.apache.avro.ipc.SocketTransceiver;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.reflect.ReflectRequestor;
import org.apache.avro.ipc.reflect.ReflectResponder;
import org.apache.avro.reflect.ReflectData;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestProtocolReflect {
    private static boolean throwUndeclaredError;
    protected static Server server;
    protected static Transceiver client;
    protected static Simple proxy;

    @Before
    public void testStartServer() throws Exception {
        if (server != null) {
            return;
        }
        server = new SocketServer((Responder)new ReflectResponder(Simple.class, (Object)new TestImpl()), (SocketAddress)new InetSocketAddress(0));
        server.start();
        client = new SocketTransceiver((SocketAddress)new InetSocketAddress(server.getPort()));
        proxy = (Simple)ReflectRequestor.getClient(Simple.class, (Transceiver)client);
    }

    @Test
    public void testClassLoader() throws Exception {
        ClassLoader loader = new ClassLoader(){};
        ReflectResponder responder = new ReflectResponder(Simple.class, (Object)new TestImpl(), new ReflectData(loader));
        Assert.assertEquals((Object)responder.getReflectData().getClassLoader(), (Object)loader);
        ReflectRequestor requestor = new ReflectRequestor(Simple.class, client, new ReflectData(loader));
        Assert.assertEquals((Object)requestor.getReflectData().getClassLoader(), (Object)loader);
    }

    @Test
    public void testHello() throws IOException {
        String response = proxy.hello("bob");
        Assert.assertEquals((Object)"goodbye", (Object)response);
    }

    @Test
    public void testEcho() throws IOException {
        TestRecord record = new TestRecord();
        record.name = "foo";
        TestRecord echoed = proxy.echo(record);
        Assert.assertEquals((Object)record, (Object)echoed);
    }

    @Test
    public void testAdd() throws IOException {
        int result = proxy.add(1, 2);
        Assert.assertEquals((long)3L, (long)result);
    }

    @Test
    public void testEchoBytes() throws IOException {
        Random random = new Random();
        int length = random.nextInt(16384);
        byte[] data = new byte[length];
        random.nextBytes(data);
        byte[] echoed = proxy.echoBytes(data);
        Assert.assertArrayEquals((byte[])data, (byte[])echoed);
    }

    @Test
    public void testError() throws IOException {
        SimpleException error = null;
        try {
            proxy.error();
        }
        catch (SimpleException e) {
            error = e;
        }
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((Object)"foo", (Object)error.getMessage());
    }

    @Test
    public void testUndeclaredError() throws Exception {
        throwUndeclaredError = true;
        AvroRuntimeException error = null;
        try {
            proxy.error();
        }
        catch (AvroRuntimeException e) {
            error = e;
        }
        finally {
            throwUndeclaredError = false;
        }
        Assert.assertNotNull((Object)((Object)error));
        Assert.assertTrue((boolean)error.toString().contains("foo"));
    }

    @AfterClass
    public static void testStopServer() throws IOException {
        client.close();
        server.close();
    }

    public static class TestImpl
    implements Simple {
        @Override
        public String hello(String greeting) {
            return "goodbye";
        }

        @Override
        public int add(int arg1, int arg2) {
            return arg1 + arg2;
        }

        @Override
        public TestRecord echo(TestRecord record) {
            return record;
        }

        @Override
        public byte[] echoBytes(byte[] data) {
            return data;
        }

        @Override
        public void error() throws SimpleException {
            if (throwUndeclaredError) {
                throw new RuntimeException("foo");
            }
            throw new SimpleException("foo");
        }
    }

    public static interface Simple {
        public String hello(String var1);

        public TestRecord echo(TestRecord var1);

        public int add(int var1, int var2);

        public byte[] echoBytes(byte[] var1);

        public void error() throws SimpleException;
    }

    public static class TestRecord {
        private String name;

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object that) {
            return this.name.equals(((TestRecord)that).name);
        }
    }
}

