/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.avro.FooBarSpecificRecord;
import org.apache.avro.Schema;
import org.apache.avro.TestSchema;
import org.apache.avro.TypeEnum;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.test.Kind;
import org.apache.avro.test.MD5;
import org.apache.avro.test.Reserved;
import org.apache.avro.test.TestRecord;
import org.junit.Assert;
import org.junit.Test;

public class TestSpecificData {
    @Test
    public void testHashCode() {
        new TestRecord().hashCode();
        SpecificData.get().hashCode(null, TestRecord.SCHEMA$);
    }

    @Test
    public void testToString() {
        new TestRecord().toString();
    }

    @Test
    public void testGetMapSchema() throws Exception {
        SpecificData.get().getSchema(X.class.getField("map").getGenericType());
    }

    @Test
    public void testSpecificWithinGeneric() throws Exception {
        Schema schema = Schema.createRecord((String)"Foo", (String)"", (String)"x.y.z", (boolean)false);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("f", TestRecord.SCHEMA$, "", null));
        schema.setFields(fields);
        TestRecord nested = new TestRecord();
        nested.setName("foo");
        nested.setKind(Kind.BAR);
        nested.setHash(new MD5(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5}));
        GenericData.Record record = new GenericData.Record(schema);
        record.put("f", (Object)nested);
        TestSchema.checkBinary(schema, record, (DatumWriter<Object>)new SpecificDatumWriter(), (DatumReader<Object>)new SpecificDatumReader());
        TestSchema.checkDirectBinary(schema, record, (DatumWriter<Object>)new SpecificDatumWriter(), (DatumReader<Object>)new SpecificDatumReader());
        TestSchema.checkBlockingBinary(schema, record, (DatumWriter<Object>)new SpecificDatumWriter(), (DatumReader<Object>)new SpecificDatumReader());
    }

    @Test
    public void testConvertGenericToSpecific() {
        GenericData.Record generic = new GenericData.Record(TestRecord.SCHEMA$);
        generic.put("name", (Object)"foo");
        generic.put("kind", (Object)new GenericData.EnumSymbol(Kind.SCHEMA$, "BAR"));
        generic.put("hash", (Object)new GenericData.Fixed(MD5.SCHEMA$, new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5}));
        TestRecord specific = (TestRecord)((Object)SpecificData.get().deepCopy(TestRecord.SCHEMA$, (Object)generic));
    }

    @Test
    public void testGetClassSchema() throws Exception {
        Assert.assertEquals((Object)TestRecord.getClassSchema(), (Object)TestRecord.SCHEMA$);
        Assert.assertEquals((Object)MD5.getClassSchema(), (Object)MD5.SCHEMA$);
        Assert.assertEquals((Object)Kind.getClassSchema(), (Object)Kind.SCHEMA$);
    }

    @Test
    public void testSpecificRecordToString() throws IOException {
        FooBarSpecificRecord foo = FooBarSpecificRecord.newBuilder().setId(123).setName("foo").setNicknames(Collections.singletonList("bar")).setRelatedids(Arrays.asList(1, 2, 3)).setTypeEnum(TypeEnum.c).build();
        String json = foo.toString();
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createParser(json);
        ObjectMapper mapper = new ObjectMapper();
        mapper.readTree(parser);
    }

    @Test
    public void testExternalizeable() throws Exception {
        TestRecord before = new TestRecord();
        before.setName("foo");
        before.setKind(Kind.BAR);
        before.setHash(new MD5(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5}));
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeObject((Object)before);
        out.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));
        TestRecord after = (TestRecord)((Object)in.readObject());
        Assert.assertEquals((Object)((Object)before), (Object)((Object)after));
    }

    @Test
    public void testReservedEnumSymbol() throws Exception {
        Assert.assertEquals((Object)((Object)Reserved.default$), (Object)SpecificData.get().createEnum("default", Reserved.SCHEMA$));
    }

    private static class X {
        public Map<String, String> map;

        private X() {
        }
    }
}

