/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.hadoop.io;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.hadoop.io.AvroSequenceFile;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestAvroSequenceFile {
    @Rule
    public TemporaryFolder mTempDir = new TemporaryFolder();

    @Test
    public void testReadAvro() throws IOException {
        Path sequenceFilePath = new Path(new File(this.mTempDir.getRoot(), "output.seq").getPath());
        this.writeSequenceFile(sequenceFilePath, AvroKey.class, AvroValue.class, Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.INT), new AvroKey((Object)"one"), new AvroValue((Object)1), new AvroKey((Object)"two"), new AvroValue((Object)2));
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        AvroSequenceFile.Reader.Options options = new AvroSequenceFile.Reader.Options().withFileSystem(fs).withInputPath(sequenceFilePath).withKeySchema(Schema.create((Schema.Type)Schema.Type.STRING)).withValueSchema(Schema.create((Schema.Type)Schema.Type.INT)).withConfiguration(conf);
        AvroSequenceFile.Reader reader = new AvroSequenceFile.Reader(options);
        AvroKey key = new AvroKey();
        AvroValue value = new AvroValue();
        key = (AvroKey)reader.next((Object)key);
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)"one", (Object)((CharSequence)key.datum()).toString());
        value = (AvroValue)reader.getCurrentValue((Object)value);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((long)1L, (long)((Integer)value.datum()).intValue());
        key = (AvroKey)reader.next((Object)key);
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)"two", (Object)((CharSequence)key.datum()).toString());
        value = (AvroValue)reader.getCurrentValue((Object)value);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((long)2L, (long)((Integer)value.datum()).intValue());
        Assert.assertNull((String)"Should be no more records.", (Object)reader.next((Object)key));
    }

    @Test
    public void testReadAvroWithoutReaderSchemas() throws IOException {
        Path sequenceFilePath = new Path(new File(this.mTempDir.getRoot(), "output.seq").getPath());
        this.writeSequenceFile(sequenceFilePath, AvroKey.class, AvroValue.class, Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.INT), new AvroKey((Object)"one"), new AvroValue((Object)1), new AvroKey((Object)"two"), new AvroValue((Object)2));
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        AvroSequenceFile.Reader.Options options = new AvroSequenceFile.Reader.Options().withFileSystem(fs).withInputPath(sequenceFilePath).withConfiguration(conf);
        AvroSequenceFile.Reader reader = new AvroSequenceFile.Reader(options);
        AvroKey key = new AvroKey();
        AvroValue value = new AvroValue();
        key = (AvroKey)reader.next((Object)key);
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)"one", (Object)((CharSequence)key.datum()).toString());
        value = (AvroValue)reader.getCurrentValue((Object)value);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((long)1L, (long)((Integer)value.datum()).intValue());
        key = (AvroKey)reader.next((Object)key);
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((Object)"two", (Object)((CharSequence)key.datum()).toString());
        value = (AvroValue)reader.getCurrentValue((Object)value);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((long)2L, (long)((Integer)value.datum()).intValue());
        Assert.assertNull((String)"Should be no more records.", (Object)reader.next((Object)key));
    }

    @Test
    public void testReadWritables() throws IOException {
        Path sequenceFilePath = new Path(new File(this.mTempDir.getRoot(), "output.seq").getPath());
        this.writeSequenceFile(sequenceFilePath, Text.class, IntWritable.class, null, null, new Text("one"), new IntWritable(1), new Text("two"), new IntWritable(2));
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        AvroSequenceFile.Reader.Options options = new AvroSequenceFile.Reader.Options().withFileSystem(fs).withInputPath(sequenceFilePath).withConfiguration(conf);
        AvroSequenceFile.Reader reader = new AvroSequenceFile.Reader(options);
        Text key = new Text();
        IntWritable value = new IntWritable();
        Assert.assertTrue((boolean)reader.next((Writable)key));
        Assert.assertEquals((Object)"one", (Object)key.toString());
        reader.getCurrentValue((Writable)value);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((long)1L, (long)value.get());
        Assert.assertTrue((boolean)reader.next((Writable)key));
        Assert.assertEquals((Object)"two", (Object)key.toString());
        reader.getCurrentValue((Writable)value);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((long)2L, (long)value.get());
        Assert.assertFalse((String)"Should be no more records.", (boolean)reader.next((Writable)key));
    }

    private void writeSequenceFile(Path file, Class<?> keyClass, Class<?> valueClass, Schema keySchema, Schema valueSchema, Object ... records) throws IOException {
        if (0 != records.length % 2) {
            throw new IllegalArgumentException("Expected a value for each key record.");
        }
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        AvroSequenceFile.Writer.Options options = new AvroSequenceFile.Writer.Options().withFileSystem(fs).withConfiguration(conf).withOutputPath(file);
        if (null != keySchema) {
            options.withKeySchema(keySchema);
        } else {
            options.withKeyClass(keyClass);
        }
        if (null != valueSchema) {
            options.withValueSchema(valueSchema);
        } else {
            options.withValueClass(valueClass);
        }
        AvroSequenceFile.Writer writer = new AvroSequenceFile.Writer(options);
        for (int i = 0; i < records.length; i += 2) {
            writer.append(records[i], records[i + 1]);
        }
        writer.close();
    }
}

