/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.util.HashSet;
import org.apache.avro.mapred.AvroInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestAvroInputFormat {
    @Rule
    public TemporaryFolder DIR = new TemporaryFolder();
    private JobConf conf;
    private FileSystem fs;
    private Path inputDir;

    @Before
    public void setUp() throws Exception {
        this.conf = new JobConf();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.inputDir = new Path(this.DIR.getRoot().getPath());
    }

    @After
    public void tearDown() throws Exception {
        this.fs.delete(this.inputDir, true);
    }

    @Test
    public void testIgnoreFilesWithoutExtension() throws Exception {
        this.fs.mkdirs(this.inputDir);
        Path avroFile = new Path(this.inputDir, "somefile.avro");
        Path textFile = new Path(this.inputDir, "someotherfile.txt");
        this.fs.create(avroFile).close();
        this.fs.create(textFile).close();
        FileInputFormat.setInputPaths((JobConf)this.conf, (Path[])new Path[]{this.inputDir});
        AvroInputFormat inputFormat = new AvroInputFormat();
        FileStatus[] statuses = inputFormat.listStatus(this.conf);
        Assert.assertEquals((long)1L, (long)statuses.length);
        Assert.assertEquals((Object)"somefile.avro", (Object)statuses[0].getPath().getName());
        this.conf.setBoolean("avro.mapred.ignore.inputs.without.extension", false);
        statuses = inputFormat.listStatus(this.conf);
        Assert.assertEquals((long)2L, (long)statuses.length);
        HashSet<String> names = new HashSet<String>();
        names.add(statuses[0].getPath().getName());
        names.add(statuses[1].getPath().getName());
        Assert.assertTrue((boolean)names.contains("somefile.avro"));
        Assert.assertTrue((boolean)names.contains("someotherfile.txt"));
    }
}

