/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import org.apache.avro.file.CodecFactory;
import org.apache.avro.mapred.AvroOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Test;

public class TestAvroOutputFormat {
    @Test
    public void testSetSyncInterval() {
        JobConf jobConf = new JobConf();
        int newSyncInterval = 100000;
        AvroOutputFormat.setSyncInterval((JobConf)jobConf, (int)newSyncInterval);
        Assert.assertEquals((long)newSyncInterval, (long)jobConf.getInt("avro.mapred.sync.interval", -1));
    }

    @Test
    public void testNoCodec() {
        JobConf job = new JobConf();
        Assert.assertNull((Object)AvroOutputFormat.getCodecFactory((JobConf)job));
        job = new JobConf();
        job.set("mapred.output.compress", "false");
        job.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.BZip2Codec");
        Assert.assertNull((Object)AvroOutputFormat.getCodecFactory((JobConf)job));
        job = new JobConf();
        job.set("mapred.output.compress", "false");
        job.set("avro.output.codec", "bzip2");
        Assert.assertNull((Object)AvroOutputFormat.getCodecFactory((JobConf)job));
    }

    @Test
    public void testBZip2CodecUsingHadoopClass() {
        CodecFactory avroBZip2Codec = CodecFactory.fromString((String)"bzip2");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.BZip2Codec");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        Assert.assertNotNull((Object)factory);
        Assert.assertEquals(factory.getClass(), avroBZip2Codec.getClass());
    }

    @Test
    public void testBZip2CodecUsingAvroCodec() {
        CodecFactory avroBZip2Codec = CodecFactory.fromString((String)"bzip2");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("avro.output.codec", "bzip2");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        Assert.assertNotNull((Object)factory);
        Assert.assertEquals(factory.getClass(), avroBZip2Codec.getClass());
    }

    @Test
    public void testDeflateCodecUsingHadoopClass() {
        CodecFactory avroDeflateCodec = CodecFactory.fromString((String)"deflate");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.DeflateCodec");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        Assert.assertNotNull((Object)factory);
        Assert.assertEquals(factory.getClass(), avroDeflateCodec.getClass());
    }

    @Test
    public void testDeflateCodecUsingAvroCodec() {
        CodecFactory avroDeflateCodec = CodecFactory.fromString((String)"deflate");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("avro.output.codec", "deflate");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        Assert.assertNotNull((Object)factory);
        Assert.assertEquals(factory.getClass(), avroDeflateCodec.getClass());
    }

    @Test
    public void testSnappyCodecUsingHadoopClass() {
        CodecFactory avroSnappyCodec = CodecFactory.fromString((String)"snappy");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.SnappyCodec");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        Assert.assertNotNull((Object)factory);
        Assert.assertEquals(factory.getClass(), avroSnappyCodec.getClass());
    }

    @Test
    public void testSnappyCodecUsingAvroCodec() {
        CodecFactory avroSnappyCodec = CodecFactory.fromString((String)"snappy");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("avro.output.codec", "snappy");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        Assert.assertNotNull((Object)factory);
        Assert.assertEquals(factory.getClass(), avroSnappyCodec.getClass());
    }

    @Test
    public void testGZipCodecUsingHadoopClass() {
        CodecFactory avroDeflateCodec = CodecFactory.fromString((String)"deflate");
        JobConf job = new JobConf();
        job.set("mapred.output.compress", "true");
        job.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.GZipCodec");
        CodecFactory factory = AvroOutputFormat.getCodecFactory((JobConf)job);
        Assert.assertNotNull((Object)factory);
        Assert.assertEquals(factory.getClass(), avroDeflateCodec.getClass());
    }
}

