/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.AvroCollector;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroMapper;
import org.apache.avro.mapred.AvroReducer;
import org.apache.avro.mapred.Pair;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import test.Weather;

public class TestWeather {
    private static final AtomicInteger mapCloseCalls = new AtomicInteger();
    private static final AtomicInteger mapConfigureCalls = new AtomicInteger();
    private static final AtomicInteger reducerCloseCalls = new AtomicInteger();
    private static final AtomicInteger reducerConfigureCalls = new AtomicInteger();

    @After
    public void tearDown() {
        mapCloseCalls.set(0);
        mapConfigureCalls.set(0);
        reducerCloseCalls.set(0);
        reducerConfigureCalls.set(0);
    }

    @Test
    public void testMapOnly() throws Exception {
        JobConf job = new JobConf();
        String inDir = System.getProperty("share.dir", "../../../share") + "/test/data";
        Path input = new Path(inDir + "/weather.avro");
        Path output = new Path("target/test/weather-ident");
        output.getFileSystem((Configuration)job).delete(output);
        job.setJobName("identity map weather");
        AvroJob.setInputSchema((JobConf)job, (Schema)Weather.SCHEMA$);
        AvroJob.setOutputSchema((JobConf)job, (Schema)Weather.SCHEMA$);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{input});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)output);
        FileOutputFormat.setCompressOutput((JobConf)job, (boolean)true);
        job.setNumReduceTasks(0);
        JobClient.runJob((JobConf)job);
        SpecificDatumReader reader = new SpecificDatumReader();
        DataFileReader check = new DataFileReader(new File(inDir + "/weather.avro"), (DatumReader)reader);
        DataFileReader sorted = new DataFileReader(new File(output.toString() + "/part-00000.avro"), (DatumReader)reader);
        for (Weather w : sorted) {
            Assert.assertEquals((Object)check.next(), (Object)((Object)w));
        }
        check.close();
        sorted.close();
    }

    @Test
    public void testSort() throws Exception {
        JobConf job = new JobConf();
        String inDir = "../../../share/test/data";
        Path input = new Path(inDir + "/weather.avro");
        Path output = new Path("target/test/weather-sort");
        output.getFileSystem((Configuration)job).delete(output);
        job.setJobName("sort weather");
        AvroJob.setInputSchema((JobConf)job, (Schema)Weather.SCHEMA$);
        AvroJob.setMapOutputSchema((JobConf)job, (Schema)Pair.getPairSchema((Schema)Weather.SCHEMA$, (Schema)Schema.create((Schema.Type)Schema.Type.NULL)));
        AvroJob.setOutputSchema((JobConf)job, (Schema)Weather.SCHEMA$);
        AvroJob.setMapperClass((JobConf)job, SortMapper.class);
        AvroJob.setReducerClass((JobConf)job, SortReducer.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{input});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)output);
        FileOutputFormat.setCompressOutput((JobConf)job, (boolean)true);
        AvroJob.setOutputCodec((JobConf)job, (String)"snappy");
        JobClient.runJob((JobConf)job);
        SpecificDatumReader reader = new SpecificDatumReader();
        DataFileReader check = new DataFileReader(new File(inDir + "/weather-sorted.avro"), (DatumReader)reader);
        DataFileReader sorted = new DataFileReader(new File(output.toString() + "/part-00000.avro"), (DatumReader)reader);
        for (Weather w : sorted) {
            Assert.assertEquals((Object)check.next(), (Object)((Object)w));
        }
        check.close();
        sorted.close();
        Assert.assertEquals((long)1L, (long)mapCloseCalls.get());
        Assert.assertEquals((long)1L, (long)reducerCloseCalls.get());
        Assert.assertEquals((long)1L, (long)mapConfigureCalls.get());
        Assert.assertEquals((long)1L, (long)reducerConfigureCalls.get());
    }

    public static class SortReducer
    extends AvroReducer<Weather, Void, Weather> {
        public void reduce(Weather w, Iterable<Void> ignore, AvroCollector<Weather> collector, Reporter reporter) throws IOException {
            collector.collect((Object)w);
        }

        public void close() throws IOException {
            reducerCloseCalls.incrementAndGet();
        }

        public void configure(JobConf jobConf) {
            reducerConfigureCalls.incrementAndGet();
        }
    }

    public static class SortMapper
    extends AvroMapper<Weather, Pair<Weather, Void>> {
        public void map(Weather w, AvroCollector<Pair<Weather, Void>> collector, Reporter reporter) throws IOException {
            collector.collect((Object)new Pair((GenericContainer)w, (Void)null));
        }

        public void close() throws IOException {
            mapCloseCalls.incrementAndGet();
        }

        public void configure(JobConf jobConf) {
            mapConfigureCalls.incrementAndGet();
        }
    }
}

