/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.hadoop.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.hadoop.io.AvroSerializer;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroWrapper;
import org.junit.Assert;
import org.junit.Test;

public class TestAvroSerializer {
    @Test
    public void testSerialize() throws IOException {
        Schema writerSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        AvroSerializer serializer = new AvroSerializer(writerSchema);
        Assert.assertEquals((Object)writerSchema, (Object)serializer.getWriterSchema());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        serializer.open((OutputStream)outputStream);
        serializer.serialize((AvroWrapper)new AvroKey((Object)"record1"));
        serializer.serialize((AvroWrapper)new AvroKey((Object)"record2"));
        serializer.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        Schema readerSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        GenericDatumReader datumReader = new GenericDatumReader(readerSchema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)inputStream, null);
        CharSequence record = null;
        record = (CharSequence)datumReader.read(record, (Decoder)decoder);
        Assert.assertEquals((Object)"record1", (Object)record.toString());
        record = (CharSequence)datumReader.read((Object)record, (Decoder)decoder);
        Assert.assertEquals((Object)"record2", (Object)record.toString());
        inputStream.close();
    }
}

