/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestAvroKeyInputFormat {
    @Test
    public void testCreateRecordReader() throws IOException, InterruptedException {
        Job job = Job.getInstance();
        AvroJob.setInputKeySchema((Job)job, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        Configuration conf = job.getConfiguration();
        FileSplit inputSplit = (FileSplit)EasyMock.createMock(FileSplit.class);
        TaskAttemptContext context = (TaskAttemptContext)EasyMock.createMock(TaskAttemptContext.class);
        EasyMock.expect((Object)context.getConfiguration()).andReturn((Object)conf).anyTimes();
        EasyMock.replay((Object[])new Object[]{inputSplit});
        EasyMock.replay((Object[])new Object[]{context});
        AvroKeyInputFormat inputFormat = new AvroKeyInputFormat();
        RecordReader recordReader = inputFormat.createRecordReader((InputSplit)inputSplit, context);
        Assert.assertNotNull((Object)inputFormat);
        recordReader.close();
        EasyMock.verify((Object[])new Object[]{inputSplit});
        EasyMock.verify((Object[])new Object[]{context});
    }
}

