/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import org.apache.avro.mojo.AbstractAvroMojoTest;
import org.apache.avro.mojo.IDLProtocolMojo;
import org.codehaus.plexus.util.FileUtils;

public class TestIDLProtocolMojo
extends AbstractAvroMojoTest {
    protected File jodaTestPom = new File(TestIDLProtocolMojo.getBasedir(), "src/test/resources/unit/idl/pom-joda.xml");
    protected File jsr310TestPom = new File(TestIDLProtocolMojo.getBasedir(), "src/test/resources/unit/idl/pom-jsr310.xml");
    protected File injectingVelocityToolsTestPom = new File(TestIDLProtocolMojo.getBasedir(), "src/test/resources/unit/idl/pom-injecting-velocity-tools.xml");

    public void testIdlProtocolMojoJoda() throws Exception {
        IDLProtocolMojo mojo = (IDLProtocolMojo)this.lookupMojo("idl-protocol", this.jodaTestPom);
        TestIDLProtocolMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestIDLProtocolMojo.getBasedir(), "target/test-harness/idl-joda/test");
        String[] generatedFileNames = new String[]{"IdlPrivacy.java", "IdlTest.java", "IdlUser.java", "IdlUserWrapper.java"};
        String idlUserContent = FileUtils.fileRead((File)new File(outputDir, "IdlUser.java"));
        TestIDLProtocolMojo.assertTrue((boolean)idlUserContent.contains("org.joda.time.DateTime"));
    }

    public void testIdlProtocolMojoJsr310() throws Exception {
        IDLProtocolMojo mojo = (IDLProtocolMojo)this.lookupMojo("idl-protocol", this.jsr310TestPom);
        TestIDLProtocolMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestIDLProtocolMojo.getBasedir(), "target/test-harness/idl-jsr310/test");
        String[] generatedFileNames = new String[]{"IdlPrivacy.java", "IdlTest.java", "IdlUser.java", "IdlUserWrapper.java"};
        String idlUserContent = FileUtils.fileRead((File)new File(outputDir, "IdlUser.java"));
        TestIDLProtocolMojo.assertTrue((boolean)idlUserContent.contains("java.time.Instant"));
    }

    public void testSetCompilerVelocityAdditionalTools() throws Exception {
        this.injectingVelocityToolsTestPom = new File(TestIDLProtocolMojo.getBasedir(), "src/test/resources/unit/idl/pom-injecting-velocity-tools.xml");
        IDLProtocolMojo mojo = (IDLProtocolMojo)this.lookupMojo("idl-protocol", this.injectingVelocityToolsTestPom);
        TestIDLProtocolMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestIDLProtocolMojo.getBasedir(), "target/test-harness/idl/test");
        String[] generatedFiles = new String[]{"IdlPrivacy.java", "IdlTest.java", "IdlUser.java", "IdlUserWrapper.java"};
        this.assertFilesExist(outputDir, generatedFiles);
        String schemaUserContent = FileUtils.fileRead((File)new File(outputDir, "IdlUser.java"));
        TestIDLProtocolMojo.assertTrue((boolean)schemaUserContent.contains("It works!"));
    }
}

