/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import java.util.Arrays;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.entities.Person;
import org.apache.avro.mojo.InduceMojo;
import org.apache.avro.protocols.Remote;
import org.apache.avro.reflect.ReflectData;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;

public class TestInduceMojo
extends AbstractMojoTestCase {
    protected File schemaPom;
    protected File protocolPom;

    protected void setUp() throws Exception {
        String baseDir = TestInduceMojo.getBasedir();
        this.schemaPom = new File(baseDir, "src/test/resources/unit/schema/induce-pom.xml");
        this.protocolPom = new File(baseDir, "src/test/resources/unit/protocol/induce-pom.xml");
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInduceMojoExists() throws Exception {
        InduceMojo mojo = (InduceMojo)this.lookupMojo("induce", this.schemaPom);
        TestInduceMojo.assertNotNull((Object)mojo);
    }

    public void testInduceSchema() throws Exception {
        this.executeMojo(this.schemaPom);
        File outputDir = new File(TestInduceMojo.getBasedir(), "target/test-harness/schemas/org/apache/avro/entities");
        TestInduceMojo.assertTrue((outputDir.listFiles().length != 0 ? 1 : 0) != 0);
        File personSchemaFile = Arrays.stream(outputDir.listFiles()).filter(file -> file.getName().endsWith("Person.avsc")).findFirst().orElseThrow(AssertionError::new);
        TestInduceMojo.assertEquals((Object)ReflectData.get().getSchema(Person.class), (Object)new Schema.Parser().parse(personSchemaFile));
    }

    public void testInducedSchemasFileExtension() throws Exception {
        this.executeMojo(this.schemaPom);
        File outputDir = new File(TestInduceMojo.getBasedir(), "target/test-harness/schemas/org/apache/avro/entities");
        for (File file : outputDir.listFiles()) {
            TestInduceMojo.assertTrue((boolean)file.getName().contains(".avsc"));
        }
    }

    public void testInduceProtocol() throws Exception {
        this.executeMojo(this.protocolPom);
        File outputDir = new File(TestInduceMojo.getBasedir(), "target/test-harness/protocol/org/apache/avro/protocols");
        TestInduceMojo.assertTrue((outputDir.listFiles().length != 0 ? 1 : 0) != 0);
        File remoteProtocolFile = Arrays.stream(outputDir.listFiles()).filter(file -> file.getName().endsWith("Remote.avpr")).findFirst().orElseThrow(AssertionError::new);
        TestInduceMojo.assertEquals((Object)ReflectData.get().getProtocol(Remote.class), (Object)Protocol.parse((File)remoteProtocolFile));
    }

    public void testInducedProtocolsFileExtension() throws Exception {
        this.executeMojo(this.protocolPom);
        File outputDir = new File(TestInduceMojo.getBasedir(), "target/test-harness/protocol/org/apache/avro/protocols");
        for (File file : outputDir.listFiles()) {
            TestInduceMojo.assertTrue((boolean)file.getName().contains(".avpr"));
        }
    }

    private void executeMojo(File pom) throws Exception {
        InduceMojo mojo = (InduceMojo)this.lookupMojo("induce", pom);
        mojo.execute();
    }
}

