/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import org.apache.avro.mojo.AbstractAvroMojoTest;
import org.apache.avro.mojo.SchemaMojo;
import org.codehaus.plexus.util.FileUtils;

public class TestSchemaMojo
extends AbstractAvroMojoTest {
    protected File jodaTestPom = new File(TestSchemaMojo.getBasedir(), "src/test/resources/unit/schema/pom-joda.xml");
    protected File jsr310TestPom = new File(TestSchemaMojo.getBasedir(), "src/test/resources/unit/schema/pom-jsr310.xml");
    protected File injectingVelocityToolsTestPom = new File(TestSchemaMojo.getBasedir(), "src/test/resources/unit/schema/pom-injecting-velocity-tools.xml");

    public void testSchemaMojoJoda() throws Exception {
        SchemaMojo mojo = (SchemaMojo)this.lookupMojo("schema", this.jodaTestPom);
        TestSchemaMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestSchemaMojo.getBasedir(), "target/test-harness/schema-joda/test");
        String[] generatedFiles = new String[]{"PrivacyDirectImport.java", "PrivacyImport.java", "SchemaPrivacy.java", "SchemaUser.java"};
        this.assertFilesExist(outputDir, generatedFiles);
        String schemaUserContent = FileUtils.fileRead((File)new File(outputDir, "SchemaUser.java"));
        TestSchemaMojo.assertTrue((boolean)schemaUserContent.contains("org.joda.time.DateTime"));
    }

    public void testSchemaMojoJsr310() throws Exception {
        SchemaMojo mojo = (SchemaMojo)this.lookupMojo("schema", this.jsr310TestPom);
        TestSchemaMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestSchemaMojo.getBasedir(), "target/test-harness/schema-jsr310/test");
        String[] generatedFiles = new String[]{"PrivacyDirectImport.java", "PrivacyImport.java", "SchemaPrivacy.java", "SchemaUser.java"};
        this.assertFilesExist(outputDir, generatedFiles);
        String schemaUserContent = FileUtils.fileRead((File)new File(outputDir, "SchemaUser.java"));
        TestSchemaMojo.assertTrue((boolean)schemaUserContent.contains("java.time.Instant"));
    }

    public void testSetCompilerVelocityAdditionalTools() throws Exception {
        SchemaMojo mojo = (SchemaMojo)this.lookupMojo("schema", this.injectingVelocityToolsTestPom);
        TestSchemaMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestSchemaMojo.getBasedir(), "target/test-harness/schema/test");
        String[] generatedFiles = new String[]{"PrivacyDirectImport.java", "PrivacyImport.java", "SchemaPrivacy.java", "SchemaUser.java"};
        this.assertFilesExist(outputDir, generatedFiles);
        String schemaUserContent = FileUtils.fileRead((File)new File(outputDir, "SchemaUser.java"));
        TestSchemaMojo.assertTrue((boolean)schemaUserContent.contains("It works!"));
    }
}

