/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import org.apache.avro.mojo.AbstractAvroMojoTest;
import org.apache.avro.mojo.ProtocolMojo;
import org.codehaus.plexus.util.FileUtils;

public class TestProtocolMojo
extends AbstractAvroMojoTest {
    protected File jodaTestPom = new File(TestProtocolMojo.getBasedir(), "src/test/resources/unit/protocol/pom-joda.xml");
    protected File jsr310TestPom = new File(TestProtocolMojo.getBasedir(), "src/test/resources/unit/protocol/pom-jsr310.xml");
    protected File injectingVelocityToolsTestPom = new File(TestProtocolMojo.getBasedir(), "src/test/resources/unit/protocol/pom-injecting-velocity-tools.xml");

    public void testProtocolMojoJoda() throws Exception {
        ProtocolMojo mojo = (ProtocolMojo)this.lookupMojo("protocol", this.jodaTestPom);
        TestProtocolMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestProtocolMojo.getBasedir(), "target/test-harness/protocol-joda/test");
        String[] generatedFiles = new String[]{"ProtocolPrivacy.java", "ProtocolTest.java", "ProtocolUser.java"};
        this.assertFilesExist(outputDir, generatedFiles);
        String protocolUserContent = FileUtils.fileRead((File)new File(outputDir, "ProtocolUser.java"));
        TestProtocolMojo.assertTrue((boolean)protocolUserContent.contains("org.joda.time.DateTime"));
    }

    public void testProtocolMojoJsr310() throws Exception {
        ProtocolMojo mojo = (ProtocolMojo)this.lookupMojo("protocol", this.jsr310TestPom);
        TestProtocolMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestProtocolMojo.getBasedir(), "target/test-harness/protocol-jsr310/test");
        String[] generatedFiles = new String[]{"ProtocolPrivacy.java", "ProtocolTest.java", "ProtocolUser.java"};
        this.assertFilesExist(outputDir, generatedFiles);
        String protocolUserContent = FileUtils.fileRead((File)new File(outputDir, "ProtocolUser.java"));
        TestProtocolMojo.assertTrue((boolean)protocolUserContent.contains("java.time.Instant"));
    }

    public void testSetCompilerVelocityAdditionalTools() throws Exception {
        ProtocolMojo mojo = (ProtocolMojo)this.lookupMojo("protocol", this.injectingVelocityToolsTestPom);
        TestProtocolMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestProtocolMojo.getBasedir(), "target/test-harness/protocol/test");
        String[] generatedFiles = new String[]{"ProtocolPrivacy.java", "ProtocolTest.java", "ProtocolUser.java"};
        this.assertFilesExist(outputDir, generatedFiles);
        String schemaUserContent = FileUtils.fileRead((File)new File(outputDir, "ProtocolUser.java"));
        TestProtocolMojo.assertTrue((boolean)schemaUserContent.contains("It works!"));
    }
}

