/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.avro.mojo.AbstractAvroMojoTest;
import org.apache.avro.mojo.IDLProtocolMojo;
import org.codehaus.plexus.util.FileUtils;
import org.junit.Test;

public class TestIDLProtocolMojo
extends AbstractAvroMojoTest {
    private File testPom = new File(TestIDLProtocolMojo.getBasedir(), "src/test/resources/unit/idl/pom.xml");
    private File injectingVelocityToolsTestPom = new File(TestIDLProtocolMojo.getBasedir(), "src/test/resources/unit/idl/pom-injecting-velocity-tools.xml");

    @Test
    public void testIdlProtocolMojo() throws Exception {
        IDLProtocolMojo mojo = (IDLProtocolMojo)this.lookupMojo("idl-protocol", this.testPom);
        TestIDLProtocolMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestIDLProtocolMojo.getBasedir(), "target/test-harness/idl/test/");
        HashSet<String> generatedFiles = new HashSet<String>(Arrays.asList("IdlPrivacy.java", "IdlTest.java", "IdlUser.java", "IdlUserWrapper.java", "IdlClasspathImportTest.java"));
        this.assertFilesExist(outputDir, generatedFiles);
        String idlUserContent = FileUtils.fileRead((File)new File(outputDir, "IdlUser.java"));
        TestIDLProtocolMojo.assertTrue((boolean)idlUserContent.contains("java.time.Instant"));
    }

    @Test
    public void testSetCompilerVelocityAdditionalTools() throws Exception {
        IDLProtocolMojo mojo = (IDLProtocolMojo)this.lookupMojo("idl-protocol", this.injectingVelocityToolsTestPom);
        TestIDLProtocolMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestIDLProtocolMojo.getBasedir(), "target/test-harness/idl-inject/test");
        HashSet<String> generatedFiles = new HashSet<String>(Arrays.asList("IdlPrivacy.java", "IdlTest.java", "IdlUser.java", "IdlUserWrapper.java", "IdlClasspathImportTest.java"));
        this.assertFilesExist(outputDir, generatedFiles);
        String schemaUserContent = FileUtils.fileRead((File)new File(outputDir, "IdlUser.java"));
        TestIDLProtocolMojo.assertTrue((boolean)schemaUserContent.contains("It works!"));
    }
}

