/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.avro.mojo.AbstractAvroMojoTest;
import org.apache.avro.mojo.SchemaMojo;
import org.codehaus.plexus.util.FileUtils;
import org.junit.Test;

public class TestSchemaMojo
extends AbstractAvroMojoTest {
    private File testPom = new File(TestSchemaMojo.getBasedir(), "src/test/resources/unit/schema/pom.xml");
    private File injectingVelocityToolsTestPom = new File(TestSchemaMojo.getBasedir(), "src/test/resources/unit/schema/pom-injecting-velocity-tools.xml");

    @Test
    public void testSchemaMojo() throws Exception {
        SchemaMojo mojo = (SchemaMojo)this.lookupMojo("schema", this.testPom);
        TestSchemaMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestSchemaMojo.getBasedir(), "target/test-harness/schema/test");
        HashSet<String> generatedFiles = new HashSet<String>(Arrays.asList("PrivacyDirectImport.java", "PrivacyImport.java", "SchemaPrivacy.java", "SchemaUser.java"));
        this.assertFilesExist(outputDir, generatedFiles);
        String schemaUserContent = FileUtils.fileRead((File)new File(outputDir, "SchemaUser.java"));
        TestSchemaMojo.assertTrue((boolean)schemaUserContent.contains("java.time.Instant"));
    }

    @Test
    public void testSetCompilerVelocityAdditionalTools() throws Exception {
        SchemaMojo mojo = (SchemaMojo)this.lookupMojo("schema", this.injectingVelocityToolsTestPom);
        TestSchemaMojo.assertNotNull((Object)mojo);
        mojo.execute();
        File outputDir = new File(TestSchemaMojo.getBasedir(), "target/test-harness/schema-inject/test");
        HashSet<String> generatedFiles = new HashSet<String>(Arrays.asList("PrivacyDirectImport.java", "PrivacyImport.java", "SchemaPrivacy.java", "SchemaUser.java"));
        this.assertFilesExist(outputDir, generatedFiles);
        String schemaUserContent = FileUtils.fileRead((File)new File(outputDir, "SchemaUser.java"));
        TestSchemaMojo.assertTrue((String)("Got " + schemaUserContent + " instead"), (boolean)schemaUserContent.contains("It works!"));
    }
}

