/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.test.basic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.test.BasicState;
import org.apache.avro.util.Utf8;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

public class StringTest {
    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void encode(TestStateEncode state) throws Exception {
        Encoder e = state.encoder;
        int i = 0;
        while (i < state.getBatchSize()) {
            e.writeString(state.testData[i + 0]);
            e.writeString(state.testData[i + 1]);
            e.writeString(state.testData[i + 2]);
            e.writeString(state.testData[i + 3]);
            i += 4;
        }
    }

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public int decode(TestStateDecode state) throws Exception {
        Decoder d = state.decoder;
        int result = 0;
        int i = 0;
        while (i < state.getBatchSize()) {
            result += d.readString(state.utf).toString().length();
            result += d.readString(state.utf).toString().length();
            result += d.readString(state.utf).toString().length();
            result += d.readString(state.utf).toString().length();
            i += 4;
        }
        return result;
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicState {
        private byte[] testData;
        private Decoder decoder;
        private Utf8 utf = new Utf8();

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            int i = 0;
            while (i < this.getBatchSize()) {
                encoder.writeString(this.randomString());
                ++i;
            }
            this.testData = baos.toByteArray();
        }

        private String randomString() {
            char[] data = new char[super.getRandom().nextInt(70)];
            int j = 0;
            while (j < data.length) {
                data[j] = (char)(97 + super.getRandom().nextInt(25));
                ++j;
            }
            return new String(data);
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = super.newDecoder(this.testData);
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateEncode
    extends BasicState {
        private String[] testData;
        private Encoder encoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws Exception {
            this.encoder = super.newEncoder(false, this.getNullOutputStream());
            this.testData = new String[this.getBatchSize()];
            int i = 0;
            while (i < this.testData.length) {
                this.testData[i] = this.randomString();
                ++i;
            }
        }

        private String randomString() {
            char[] data = new char[super.getRandom().nextInt(70)];
            int j = 0;
            while (j < data.length) {
                data[j] = (char)(97 + super.getRandom().nextInt(25));
                ++j;
            }
            return new String(data);
        }
    }
}

