/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.protobuf.ProtobufData;
import org.apache.avro.specific.SpecificData;

public class ProtobufDatumReader<T>
extends GenericDatumReader<T> {
    public ProtobufDatumReader() {
        this(null, null, ProtobufData.get());
    }

    public ProtobufDatumReader(Class<T> c) {
        this(ProtobufData.get().getSchema(c));
    }

    public ProtobufDatumReader(Schema schema) {
        this(schema, schema, ProtobufData.get());
    }

    public ProtobufDatumReader(Schema writer, Schema reader) {
        this(writer, reader, ProtobufData.get());
    }

    protected ProtobufDatumReader(Schema writer, Schema reader, ProtobufData data) {
        super(writer, reader, (GenericData)data);
    }

    protected Object readRecord(Object old, Schema expected, ResolvingDecoder in) throws IOException {
        Message.Builder b = (Message.Builder)super.readRecord(old, expected, in);
        return b.build();
    }

    protected Object createEnum(String symbol, Schema schema) {
        try {
            Class<?> c = Class.forName(SpecificData.getClassName((Schema)schema));
            if (c == null) {
                return super.createEnum(symbol, schema);
            }
            return Enum.valueOf(c, symbol);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Object readBytes(Object old, Decoder in) throws IOException {
        return ByteString.copyFrom((byte[])((ByteBuffer)super.readBytes(old, in)).array());
    }
}

