/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.protobuf;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.protobuf.ProtobufDatumReader;
import org.apache.avro.protobuf.ProtobufDatumWriter;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.util.internal.Accessor;

public class ProtobufData
extends GenericData {
    private static final String PROTOBUF_TYPE = "protobuf";
    private static final ProtobufData INSTANCE = new ProtobufData();
    private final Map<Descriptors.Descriptor, Descriptors.FieldDescriptor[]> fieldCache = new ConcurrentHashMap<Descriptors.Descriptor, Descriptors.FieldDescriptor[]>();
    private final Map<Object, Schema> schemaCache = new ConcurrentHashMap<Object, Schema>();
    private static final ThreadLocal<Map<Descriptors.Descriptor, Schema>> SEEN = ThreadLocal.withInitial(IdentityHashMap::new);
    private static final Schema NULL = Schema.create((Schema.Type)Schema.Type.NULL);
    private static final JsonFactory FACTORY = new JsonFactory();
    private static final ObjectMapper MAPPER = new ObjectMapper(FACTORY);
    private static final JsonNodeFactory NODES = JsonNodeFactory.instance;

    protected ProtobufData() {
    }

    public static ProtobufData get() {
        return INSTANCE;
    }

    public DatumReader createDatumReader(Schema schema) {
        return new ProtobufDatumReader(schema, schema, this);
    }

    public DatumWriter createDatumWriter(Schema schema) {
        return new ProtobufDatumWriter(schema, this);
    }

    public void setField(Object r, String n, int pos, Object o) {
        this.setField(r, n, pos, o, this.getRecordState(r, this.getSchema(r.getClass())));
    }

    public Object getField(Object r, String name, int pos) {
        return this.getField(r, name, pos, this.getRecordState(r, this.getSchema(r.getClass())));
    }

    protected void setField(Object r, String n, int pos, Object o, Object state) {
        Message.Builder b = (Message.Builder)r;
        Descriptors.FieldDescriptor f = ((Descriptors.FieldDescriptor[])state)[pos];
        switch (f.getType()) {
            case MESSAGE: {
                if (o == null) {
                    b.clearField(f);
                    break;
                }
            }
            default: {
                b.setField(f, o);
            }
        }
    }

    protected Object getField(Object record, String name, int pos, Object state) {
        Message m = (Message)record;
        Descriptors.FieldDescriptor f = ((Descriptors.FieldDescriptor[])state)[pos];
        switch (f.getType()) {
            case MESSAGE: {
                if (f.isRepeated() || m.hasField(f)) break;
                return null;
            }
        }
        return m.getField(f);
    }

    protected Object getRecordState(Object r, Schema s) {
        Descriptors.Descriptor d = ((MessageOrBuilder)r).getDescriptorForType();
        Descriptors.FieldDescriptor[] fields = this.fieldCache.get(d);
        if (fields == null) {
            fields = new Descriptors.FieldDescriptor[s.getFields().size()];
            for (Schema.Field f : s.getFields()) {
                fields[f.pos()] = d.findFieldByName(f.name());
            }
            this.fieldCache.put(d, fields);
        }
        return fields;
    }

    protected boolean isRecord(Object datum) {
        return datum instanceof Message;
    }

    public Object newRecord(Object old, Schema schema) {
        try {
            Class c = SpecificData.get().getClass(schema);
            if (c == null) {
                return this.newRecord(old, schema);
            }
            if (c.isInstance(old)) {
                return old;
            }
            return c.getMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isArray(Object datum) {
        return datum instanceof List;
    }

    protected boolean isBytes(Object datum) {
        return datum instanceof ByteString;
    }

    protected Schema getRecordSchema(Object record) {
        Descriptors.Descriptor descriptor = ((Message)record).getDescriptorForType();
        Schema schema = this.schemaCache.get(descriptor);
        if (schema == null) {
            schema = this.getSchema(descriptor);
            this.schemaCache.put(descriptor, schema);
        }
        return schema;
    }

    public Schema getSchema(Class c) {
        Schema schema = this.schemaCache.get(c);
        if (schema == null) {
            try {
                Object descriptor = c.getMethod("getDescriptor", new Class[0]).invoke(null, new Object[0]);
                schema = c.isEnum() ? this.getSchema((Descriptors.EnumDescriptor)descriptor) : this.getSchema((Descriptors.Descriptor)descriptor);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.schemaCache.put(c, schema);
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema getSchema(Descriptors.Descriptor descriptor) {
        Map<Descriptors.Descriptor, Schema> seen = SEEN.get();
        if (seen.containsKey(descriptor)) {
            return seen.get(descriptor);
        }
        boolean first = seen.isEmpty();
        try {
            Schema result = Schema.createRecord((String)descriptor.getName(), null, (String)this.getNamespace(descriptor.getFile(), descriptor.getContainingType()), (boolean)false);
            seen.put(descriptor, result);
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
            for (Descriptors.FieldDescriptor f : descriptor.getFields()) {
                fields.add(Accessor.createField((String)f.getName(), (Schema)this.getSchema(f), null, (JsonNode)this.getDefault(f)));
            }
            result.setFields(fields);
            Schema schema = result;
            return schema;
        }
        finally {
            if (first) {
                seen.clear();
            }
        }
    }

    private String getNamespace(Descriptors.FileDescriptor fd, Descriptors.Descriptor containing) {
        String outer;
        String p;
        DescriptorProtos.FileOptions o = fd.getOptions();
        String string = p = o.hasJavaPackage() ? o.getJavaPackage() : fd.getPackage();
        if (o.hasJavaOuterClassname()) {
            outer = o.getJavaOuterClassname();
        } else {
            outer = new File(fd.getName()).getName();
            outer = outer.substring(0, outer.lastIndexOf(46));
            outer = ProtobufData.toCamelCase(outer);
        }
        StringBuilder inner = new StringBuilder();
        while (containing != null) {
            inner.insert(0, "$" + containing.getName());
            containing = containing.getContainingType();
        }
        return p + "." + outer + inner;
    }

    private static String toCamelCase(String s) {
        String[] parts = s.split("_");
        StringBuilder camelCaseString = new StringBuilder();
        for (String part : parts) {
            camelCaseString.append(ProtobufData.cap(part));
        }
        return camelCaseString.toString();
    }

    private static String cap(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    private Schema getSchema(Descriptors.FieldDescriptor f) {
        Schema s = this.getNonRepeatedSchema(f);
        if (f.isRepeated()) {
            s = Schema.createArray((Schema)s);
        }
        return s;
    }

    private Schema getNonRepeatedSchema(Descriptors.FieldDescriptor f) {
        switch (f.getType()) {
            case BOOL: {
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case FLOAT: {
                return Schema.create((Schema.Type)Schema.Type.FLOAT);
            }
            case DOUBLE: {
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case STRING: {
                Schema s = Schema.create((Schema.Type)Schema.Type.STRING);
                GenericData.setStringType((Schema)s, (GenericData.StringType)GenericData.StringType.String);
                return s;
            }
            case BYTES: {
                return Schema.create((Schema.Type)Schema.Type.BYTES);
            }
            case INT32: 
            case UINT32: 
            case SINT32: 
            case FIXED32: 
            case SFIXED32: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case INT64: 
            case UINT64: 
            case SINT64: 
            case FIXED64: 
            case SFIXED64: {
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case ENUM: {
                return this.getSchema(f.getEnumType());
            }
            case MESSAGE: {
                Schema result = this.getSchema(f.getMessageType());
                if (f.isOptional()) {
                    result = Schema.createUnion(Arrays.asList(NULL, result));
                }
                return result;
            }
        }
        throw new RuntimeException("Unexpected type: " + f.getType());
    }

    public Schema getSchema(Descriptors.EnumDescriptor d) {
        ArrayList<String> symbols = new ArrayList<String>();
        for (Descriptors.EnumValueDescriptor e : d.getValues()) {
            symbols.add(e.getName());
        }
        return Schema.createEnum((String)d.getName(), null, (String)this.getNamespace(d.getFile(), d.getContainingType()), symbols);
    }

    private JsonNode getDefault(Descriptors.FieldDescriptor f) {
        if (f.isRequired() || f.isRepeated()) {
            return null;
        }
        if (f.hasDefaultValue()) {
            Object value = f.getDefaultValue();
            switch (f.getType()) {
                case ENUM: {
                    value = ((Descriptors.EnumValueDescriptor)value).getName();
                }
            }
            String json = this.toString(value);
            try {
                return (JsonNode)MAPPER.readTree(FACTORY.createParser(json));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        switch (f.getType()) {
            case BOOL: {
                return NODES.booleanNode(false);
            }
            case FLOAT: 
            case DOUBLE: 
            case INT32: 
            case UINT32: 
            case SINT32: 
            case FIXED32: 
            case SFIXED32: 
            case INT64: 
            case UINT64: 
            case SINT64: 
            case FIXED64: 
            case SFIXED64: {
                return NODES.numberNode(0);
            }
            case STRING: 
            case BYTES: {
                return NODES.textNode("");
            }
            case ENUM: {
                return NODES.textNode(((Descriptors.EnumValueDescriptor)f.getEnumType().getValues().get(0)).getName());
            }
            case MESSAGE: {
                return NODES.nullNode();
            }
        }
        throw new RuntimeException("Unexpected type: " + f.getType());
    }
}

