/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.thrift;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.thrift.ThriftData;
import org.apache.avro.thrift.ThriftDatumReader;
import org.apache.avro.thrift.ThriftDatumWriter;
import org.apache.avro.thrift.test.E;
import org.apache.avro.thrift.test.FooOrBar;
import org.apache.avro.thrift.test.Nested;
import org.apache.avro.thrift.test.Test;
import org.junit.Assert;

public class TestThrift {
    @org.junit.Test
    public void testStruct() throws Exception {
        System.out.println(ThriftData.get().getSchema(Test.class).toString(true));
        Test test = new Test();
        test.setBoolField(true);
        test.setByteField((byte)2);
        test.setI16Field((short)3);
        test.setI16OptionalField((short)14);
        test.setI32Field(4);
        test.setI64Field(5L);
        test.setDoubleField(2.0);
        test.setStringField("foo");
        byte[] byArray = new byte[2];
        byArray[1] = -1;
        test.setBinaryField(ByteBuffer.wrap(byArray));
        test.setMapField(Collections.singletonMap("x", 1));
        test.setListField(Collections.singletonList(7));
        test.setSetField(Collections.singleton(8));
        test.setEnumField(E.X);
        test.setStructField(new Nested(9));
        test.setFooOrBar(FooOrBar.foo("x"));
        System.out.println(test);
        this.check(test);
    }

    @org.junit.Test
    public void testOptionals() throws Exception {
        Test test = new Test();
        test.setBoolField(true);
        test.setByteField((byte)2);
        test.setByteOptionalField((byte)4);
        test.setI16Field((short)3);
        test.setI16OptionalField((short)15);
        test.setI64Field(5L);
        test.setDoubleField(2.0);
        System.out.println(test);
        this.check(test);
    }

    private void check(Test test) throws Exception {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        ThriftDatumWriter w = new ThriftDatumWriter(Test.class);
        BinaryEncoder e = EncoderFactory.get().binaryEncoder((OutputStream)bao, null);
        w.write((Object)test, (Encoder)e);
        e.flush();
        Object o = new ThriftDatumReader(Test.class).read(null, (Decoder)DecoderFactory.get().binaryDecoder((InputStream)new ByteArrayInputStream(bao.toByteArray()), null));
        Assert.assertEquals((Object)test, (Object)o);
    }
}

