/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.security.http;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.security.http.RMAuthenticationFilter;

@InterfaceStability.Unstable
public class RMAuthenticationFilterInitializer
extends FilterInitializer {
    String configPrefix = "hadoop.http.authentication.";
    String kerberosPrincipalProperty = "kerberos.principal";
    String cookiePath = "/";

    protected Map<String, String> createFilterConfig(Configuration conf) {
        HashMap<String, String> filterConfig = new HashMap<String, String>();
        filterConfig.put("cookie.path", this.cookiePath);
        for (Map.Entry<String, String> entry : conf) {
            String name;
            String value;
            String propName = entry.getKey();
            if (propName.startsWith(this.configPrefix)) {
                value = conf.get(propName);
                name = propName.substring(this.configPrefix.length());
                filterConfig.put(name, value);
                continue;
            }
            if (!propName.startsWith("hadoop.proxyuser")) continue;
            value = conf.get(propName);
            name = propName.substring("hadoop.".length());
            filterConfig.put(name, value);
        }
        String bindAddress = conf.get("bind.address");
        String principal = (String)filterConfig.get(this.kerberosPrincipalProperty);
        if (principal != null) {
            try {
                principal = SecurityUtil.getServerPrincipal(principal, bindAddress);
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not resolve Kerberos principal name: " + ex.toString(), ex);
            }
            filterConfig.put("kerberos.principal", principal);
        }
        filterConfig.put("delegation-token.token-kind", RMDelegationTokenIdentifier.KIND_NAME.toString());
        return filterConfig;
    }

    @Override
    public void initFilter(FilterContainer container, Configuration conf) {
        Map<String, String> filterConfig = this.createFilterConfig(conf);
        container.addFilter("RMAuthenticationFilter", RMAuthenticationFilter.class.getName(), filterConfig);
    }
}

