/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.hamlet;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public class HamletGen {
    static final Logger LOG = LoggerFactory.getLogger(HamletGen.class);
    static final Options opts = new Options();
    static final Pattern elementRegex;
    int bytes = 0;
    PrintWriter out;
    final Set<String> endTagOptional = Sets.newHashSet();
    final Set<String> inlineElements = Sets.newHashSet();
    Class<?> top;
    String hamlet;
    boolean topMode;

    public void generate(Class<?> specClass, Class<?> implClass, String outputName, String outputPkg) throws IOException {
        LOG.info("Generating {} using {} and {}", outputName, specClass, implClass);
        this.out = new PrintWriter(outputName + ".java", "UTF-8");
        this.hamlet = this.basename(outputName);
        String pkg = this.pkgName(outputPkg, implClass.getPackage().getName());
        this.puts(0, "// Generated by HamletGen. Do NOT edit!\n", "package ", pkg, ";\n", "import java.io.PrintWriter;\n", "import java.util.EnumSet;\n", "import static java.util.EnumSet.*;\n", "import static ", implClass.getName(), ".EOpt.*;\n", "import org.apache.hadoop.yarn.webapp.SubView;");
        String implClassName = implClass.getSimpleName();
        if (!implClass.getPackage().getName().equals(pkg)) {
            this.puts(0, "import ", implClass.getName(), Character.valueOf(';'));
        }
        this.puts(0, "\n", "public class ", this.hamlet, " extends ", implClassName, " implements ", specClass.getSimpleName(), "._Html {\n", "  public ", this.hamlet, "(PrintWriter out, int nestLevel,", " boolean wasInline) {\n", "    super(out, nestLevel, wasInline);\n", "  }\n\n", "  static EnumSet<EOpt> opt(boolean endTag, boolean inline, ", "boolean pre) {\n", "    EnumSet<EOpt> opts = of(ENDTAG);\n", "    if (!endTag) opts.remove(ENDTAG);\n", "    if (inline) opts.add(INLINE);\n", "    if (pre) opts.add(PRE);\n", "    return opts;\n", "  }");
        this.initLut(specClass);
        this.genImpl(specClass, implClassName, 1);
        LOG.info("Generating {} methods", (Object)this.hamlet);
        this.genMethods(this.hamlet, this.top, 1);
        this.puts(0, "}");
        this.out.close();
        LOG.info("Wrote {} bytes to {}.java", (Object)this.bytes, (Object)outputName);
    }

    String basename(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    String pkgName(String pkg, String defaultPkg) {
        if (pkg == null || pkg.isEmpty()) {
            return defaultPkg;
        }
        return pkg;
    }

    void initLut(Class<?> spec) {
        this.endTagOptional.clear();
        this.inlineElements.clear();
        for (Class<?> cls : spec.getClasses()) {
            HamletSpec.Element a = cls.getAnnotation(HamletSpec.Element.class);
            if (a != null && !a.endTag()) {
                this.endTagOptional.add(cls.getSimpleName());
            }
            if (!cls.getSimpleName().equals("Inline")) continue;
            for (Method method : cls.getMethods()) {
                String retName = method.getReturnType().getSimpleName();
                if (!this.isElement(retName)) continue;
                this.inlineElements.add(retName);
            }
        }
    }

    void genImpl(Class<?> spec, String implClassName, int indent) {
        String specName = spec.getSimpleName();
        for (Class<?> cls : spec.getClasses()) {
            String className = cls.getSimpleName();
            if (cls.isInterface()) {
                this.genFactoryMethods(cls, indent);
            }
            if (this.isElement(className)) {
                LOG.info("Generating class {}<T>", (Object)className);
                this.puts(indent, "\n", "public class ", className, "<T extends _>", " extends EImp<T> implements ", specName, ".", className, " {\n", "  public ", className, "(String name, T parent,", " EnumSet<EOpt> opts) {\n", "    super(name, parent, opts);\n", "  }");
                this.genMethods(className, cls, indent + 1);
                this.puts(indent, "}");
                continue;
            }
            if (!className.equals("_Html")) continue;
            this.top = cls;
        }
    }

    void genFactoryMethods(Class<?> cls, int indent) {
        for (Method method : cls.getDeclaredMethods()) {
            String retName = method.getReturnType().getSimpleName();
            String methodName = method.getName();
            if (methodName.charAt(0) == '$' || !this.isElement(retName) || method.getParameterTypes().length != 0) continue;
            this.genFactoryMethod(retName, methodName, indent);
        }
    }

    void genMethods(String className, Class<?> cls, int indent) {
        this.topMode = this.top != null && cls.equals(this.top);
        for (Method method : cls.getMethods()) {
            String retName = method.getReturnType().getSimpleName();
            if (method.getName().charAt(0) == '$') {
                this.genAttributeMethod(className, method, indent);
                continue;
            }
            if (this.isElement(retName)) {
                this.genNewElementMethod(className, method, indent);
                continue;
            }
            this.genCurElementMethod(className, method, indent);
        }
    }

    void genAttributeMethod(String className, Method method, int indent) {
        String methodName = method.getName();
        String attrName = methodName.substring(1).replace('_', '-');
        Type[] params = method.getGenericParameterTypes();
        this.echo(indent, "\n", "@Override\n", "public ", className, this.topMode ? " " : "<T> ", methodName, "(");
        if (params.length == 0) {
            this.puts(0, ") {");
            this.puts(indent, "  addAttr(\"", attrName, "\", null);\n", "  return this;\n", "}");
        } else if (params.length == 1) {
            String typeName = this.getTypeName(params[0]);
            this.puts(0, typeName, " value) {");
            if (typeName.equals("EnumSet<LinkType>")) {
                this.puts(indent, "  addRelAttr(\"", attrName, "\", value);\n", "  return this;\n", "}");
            } else if (typeName.equals("EnumSet<Media>")) {
                this.puts(indent, "  addMediaAttr(\"", attrName, "\", value);\n", "  return this;\n", "}");
            } else {
                this.puts(indent, "  addAttr(\"", attrName, "\", value);\n", "  return this;\n", "}");
            }
        } else {
            HamletGen.throwUnhandled(className, method);
        }
    }

    String getTypeName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        ParameterizedType pt = (ParameterizedType)type;
        return ((Class)pt.getRawType()).getSimpleName() + "<" + ((Class)pt.getActualTypeArguments()[0]).getSimpleName() + ">";
    }

    void genFactoryMethod(String retName, String methodName, int indent) {
        this.puts(indent, "\n", "private <T extends _> ", retName, "<T> ", methodName, "_(T e, boolean inline) {\n", "  return new ", retName, "<T>(\"", StringUtils.toLowerCase(retName), "\", e, opt(", !this.endTagOptional.contains(retName), ", inline, ", retName.equals("PRE"), ")); }");
    }

    void genNewElementMethod(String className, Method method, int indent) {
        String methodName = method.getName();
        String retName = method.getReturnType().getSimpleName();
        Class<?>[] params = method.getParameterTypes();
        this.echo(indent, "\n", "@Override\n", "public ", retName, "<", className, this.topMode ? "> " : "<T>> ", methodName, "(");
        if (params.length == 0) {
            this.puts(0, ") {");
            this.puts(indent, this.topMode ? "" : "  closeAttrs();\n", "  return ", StringUtils.toLowerCase(retName), "_(this, ", this.isInline(className, retName), ");\n", "}");
        } else if (params.length == 1) {
            this.puts(0, "String selector) {");
            this.puts(indent, "  return setSelector(", methodName, "(), selector);\n", "}");
        } else {
            HamletGen.throwUnhandled(className, method);
        }
    }

    boolean isInline(String container, String className) {
        if ((container.equals("BODY") || container.equals(this.hamlet) || container.equals("HEAD") || container.equals("HTML")) && (className.equals("INS") || className.equals("DEL") || className.equals("SCRIPT"))) {
            return false;
        }
        return this.inlineElements.contains(className);
    }

    void genCurElementMethod(String className, Method method, int indent) {
        String methodName = method.getName();
        Class<?>[] params = method.getParameterTypes();
        if (this.topMode || params.length > 0) {
            this.echo(indent, "\n", "@Override\n", "public ", className, this.topMode ? " " : "<T> ", methodName, "(");
        }
        if (params.length == 0) {
            if (this.topMode) {
                this.puts(0, ") {");
                this.puts(indent, "  return this;\n", "}");
            }
        } else if (params.length == 1) {
            if (methodName.equals("base")) {
                this.puts(0, "String href) {");
                this.puts(indent, "  return base().$href(href)._();\n", "}");
            } else if (methodName.equals("script")) {
                this.puts(0, "String src) {");
                this.puts(indent, "  return setScriptSrc(script(), src)._();\n", "}");
            } else if (methodName.equals("style")) {
                this.puts(0, "Object... lines) {");
                this.puts(indent, "  return style().$type(\"text/css\")._(lines)._();\n", "}");
            } else if (methodName.equals("img")) {
                this.puts(0, "String src) {");
                this.puts(indent, "  return ", methodName, "().$src(src)._();\n", "}");
            } else if (methodName.equals("br") || methodName.equals("hr") || methodName.equals("col")) {
                this.puts(0, "String selector) {");
                this.puts(indent, "  return setSelector(", methodName, "(), selector)._();\n", "}");
            } else if (methodName.equals("link")) {
                this.puts(0, "String href) {");
                this.puts(indent, "  return setLinkHref(", methodName, "(), href)._();\n", "}");
            } else if (methodName.equals("_")) {
                if (params[0].getSimpleName().equals("Class")) {
                    this.puts(0, "Class<? extends SubView> cls) {");
                    this.puts(indent, "  ", this.topMode ? "subView" : "_v", "(cls);\n", "  return this;\n", "}");
                } else {
                    this.puts(0, "Object... lines) {");
                    this.puts(indent, "  _p(", HamletGen.needsEscaping(className), ", lines);\n", "  return this;\n", "}");
                }
            } else if (methodName.equals("_r")) {
                this.puts(0, "Object... lines) {");
                this.puts(indent, "  _p(false, lines);\n", "  return this;\n", "}");
            } else {
                this.puts(0, "String cdata) {");
                this.puts(indent, "  return ", methodName, "()._(cdata)._();\n", "}");
            }
        } else if (params.length == 2) {
            if (methodName.equals("meta")) {
                this.puts(0, "String name, String content) {");
                this.puts(indent, "  return meta().$name(name).$content(content)._();\n", "}");
            } else if (methodName.equals("meta_http")) {
                this.puts(0, "String header, String content) {");
                this.puts(indent, "  return meta().$http_equiv(header).$content(content)._();\n", "}");
            } else if (methodName.equals("a")) {
                this.puts(0, "String href, String anchorText) {");
                this.puts(indent, "  return a().$href(href)._(anchorText)._();\n", "}");
            } else if (methodName.equals("bdo")) {
                this.puts(0, "Dir dir, String cdata) {");
                this.puts(indent, "  return bdo().$dir(dir)._(cdata)._();\n", "}");
            } else if (methodName.equals("label")) {
                this.puts(0, "String forId, String cdata) {");
                this.puts(indent, "  return label().$for(forId)._(cdata)._();\n", "}");
            } else if (methodName.equals("param")) {
                this.puts(0, "String name, String value) {");
                this.puts(indent, "  return param().$name(name).$value(value)._();\n", "}");
            } else {
                this.puts(0, "String selector, String cdata) {");
                this.puts(indent, "  return setSelector(", methodName, "(), selector)._(cdata)._();\n", "}");
            }
        } else if (params.length == 3) {
            if (methodName.equals("a")) {
                this.puts(0, "String selector, String href, String anchorText) {");
                this.puts(indent, "  return setSelector(a(), selector)", ".$href(href)._(anchorText)._();\n", "}");
            }
        } else {
            HamletGen.throwUnhandled(className, method);
        }
    }

    static boolean needsEscaping(String eleName) {
        return !eleName.equals("SCRIPT") && !eleName.equals("STYLE");
    }

    static void throwUnhandled(String className, Method method) {
        throw new WebAppException("Unhandled " + className + "#" + method);
    }

    void echo(int indent, Object ... args) {
        String prev = null;
        for (Object o : args) {
            String s = String.valueOf(o);
            if (!(s.isEmpty() || s.equals("\n") || prev != null && !prev.endsWith("\n"))) {
                this.indent(indent);
            }
            prev = s;
            this.out.print(s);
            this.bytes += s.length();
        }
    }

    void indent(int indent) {
        for (int i = 0; i < indent; ++i) {
            this.out.print("  ");
            this.bytes += 2;
        }
    }

    void puts(int indent, Object ... args) {
        this.echo(indent, args);
        this.out.println();
        ++this.bytes;
    }

    boolean isElement(String s) {
        return elementRegex.matcher(s).matches();
    }

    public static void main(String[] args) throws Exception {
        CommandLine cmd = new GnuParser().parse(opts, args);
        if (cmd.hasOption("help")) {
            new HelpFormatter().printHelp("Usage: hbgen [OPTIONS]", opts);
            return;
        }
        Class specClass = HamletSpec.class;
        Class implClass = HamletImpl.class;
        String outputClass = "HamletTmp";
        String outputPackage = implClass.getPackage().getName();
        if (cmd.hasOption("spec-class")) {
            specClass = Class.forName(cmd.getOptionValue("spec-class"));
        }
        if (cmd.hasOption("impl-class")) {
            implClass = Class.forName(cmd.getOptionValue("impl-class"));
        }
        if (cmd.hasOption("output-class")) {
            outputClass = cmd.getOptionValue("output-class");
        }
        if (cmd.hasOption("output-package")) {
            outputPackage = cmd.getOptionValue("output-package");
        }
        new HamletGen().generate(specClass, implClass, outputClass, outputPackage);
    }

    static {
        opts.addOption("h", "help", false, "Print this help message").addOption("s", "spec-class", true, "The class that holds the spec interfaces. e.g. HamletSpec").addOption("i", "impl-class", true, "An implementation class. e.g. HamletImpl").addOption("o", "output-class", true, "Output class name").addOption("p", "output-package", true, "Output package name");
        elementRegex = Pattern.compile("^[A-Z][A-Z0-9]*$");
    }
}

