/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.ColumnFileReader;
import org.apache.trevni.ColumnFileWriter;
import org.apache.trevni.ColumnMetaData;
import org.apache.trevni.ColumnValues;
import org.apache.trevni.TestUtil;
import org.apache.trevni.ValueType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestColumnFile {
    private static final File FILE = new File("target", "test.trv");
    private static final int COUNT = 65536;
    private String codec;
    private String checksum;

    public TestColumnFile(String codec, String checksum) {
        this.codec = codec;
        this.checksum = checksum;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> codecs() {
        Object[][] data = new Object[][]{{"null", "null"}, {"snappy", "crc32"}, {"deflate", "crc32"}};
        return Arrays.asList(data);
    }

    private ColumnFileMetaData createFileMeta() {
        return (ColumnFileMetaData)((ColumnFileMetaData)new ColumnFileMetaData().setCodec(this.codec)).setChecksum(this.checksum);
    }

    @Test
    public void testEmptyFile() throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(this.createFileMeta(), new ColumnMetaData[0]);
        out.writeTo(FILE);
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assert.assertEquals((long)0L, (long)in.getRowCount());
        Assert.assertEquals((long)0L, (long)in.getColumnCount());
        in.close();
    }

    @Test
    public void testEmptyColumn() throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(this.createFileMeta(), new ColumnMetaData("test", ValueType.INT));
        out.writeTo(FILE);
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assert.assertEquals((long)0L, (long)in.getRowCount());
        Assert.assertEquals((long)1L, (long)in.getColumnCount());
        ColumnValues values = in.getValues("test");
        Iterator iterator = values.iterator();
        if (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            throw new Exception("no value should be found");
        }
        in.close();
    }

    @Test
    public void testInts() throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(this.createFileMeta(), new ColumnMetaData("test", ValueType.INT));
        Random random = TestUtil.createRandom();
        int i = 0;
        while (i < 65536) {
            out.writeRow(TestUtil.randomLength(random));
            ++i;
        }
        out.writeTo(FILE);
        random = TestUtil.createRandom();
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assert.assertEquals((long)65536L, (long)in.getRowCount());
        Assert.assertEquals((long)1L, (long)in.getColumnCount());
        ColumnValues i2 = in.getValues("test");
        int count = 0;
        while (i2.hasNext()) {
            Assert.assertEquals((long)TestUtil.randomLength(random), (long)((Integer)i2.next()).intValue());
            ++count;
        }
        Assert.assertEquals((long)65536L, (long)count);
    }

    @Test
    public void testLongs() throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(this.createFileMeta(), new ColumnMetaData("test", ValueType.LONG));
        Random random = TestUtil.createRandom();
        int i = 0;
        while (i < 65536) {
            out.writeRow(random.nextLong());
            ++i;
        }
        out.writeTo(FILE);
        random = TestUtil.createRandom();
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assert.assertEquals((long)65536L, (long)in.getRowCount());
        Assert.assertEquals((long)1L, (long)in.getColumnCount());
        ColumnValues i2 = in.getValues("test");
        int count = 0;
        while (i2.hasNext()) {
            Assert.assertEquals((long)random.nextLong(), (long)((Long)i2.next()));
            ++count;
        }
        Assert.assertEquals((long)65536L, (long)count);
    }

    @Test
    public void testStrings() throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(this.createFileMeta(), new ColumnMetaData("test", ValueType.STRING));
        Random random = TestUtil.createRandom();
        int i = 0;
        while (i < 65536) {
            out.writeRow(TestUtil.randomString(random));
            ++i;
        }
        out.writeTo(FILE);
        random = TestUtil.createRandom();
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assert.assertEquals((long)65536L, (long)in.getRowCount());
        Assert.assertEquals((long)1L, (long)in.getColumnCount());
        ColumnValues i2 = in.getValues("test");
        int count = 0;
        while (i2.hasNext()) {
            Assert.assertEquals((Object)TestUtil.randomString(random), i2.next());
            ++count;
        }
        Assert.assertEquals((long)65536L, (long)count);
    }

    @Test
    public void testTwoColumn() throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(this.createFileMeta(), new ColumnMetaData("a", ValueType.FIXED32), new ColumnMetaData("b", ValueType.STRING));
        Random random = TestUtil.createRandom();
        int i = 0;
        while (i < 65536) {
            out.writeRow(random.nextInt(), TestUtil.randomString(random));
            ++i;
        }
        out.writeTo(FILE);
        random = TestUtil.createRandom();
        ColumnFileReader in = new ColumnFileReader(FILE);
        Assert.assertEquals((long)65536L, (long)in.getRowCount());
        Assert.assertEquals((long)2L, (long)in.getColumnCount());
        ColumnValues i2 = in.getValues("a");
        ColumnValues j = in.getValues("b");
        int count = 0;
        while (i2.hasNext() && j.hasNext()) {
            Assert.assertEquals((Object)random.nextInt(), i2.next());
            Assert.assertEquals((Object)TestUtil.randomString(random), j.next());
            ++count;
        }
        Assert.assertEquals((long)65536L, (long)count);
    }

    @Test
    public void testSeekLongs() throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(this.createFileMeta(), new ColumnMetaData("test", ValueType.LONG));
        Random random = TestUtil.createRandom();
        int seekCount = 64;
        int[] seekRows = new int[seekCount];
        HashMap<Integer, Integer> seekRowMap = new HashMap<Integer, Integer>(seekCount);
        while (seekRowMap.size() < seekCount) {
            int row = random.nextInt(65536);
            if (seekRowMap.containsKey(row)) continue;
            seekRows[seekRowMap.size()] = row;
            seekRowMap.put(row, seekRowMap.size());
        }
        Long[] seekValues = new Long[seekCount];
        int i = 0;
        while (i < 65536) {
            long l = random.nextLong();
            out.writeRow(l);
            if (seekRowMap.containsKey(i)) {
                seekValues[((Integer)seekRowMap.get((Object)Integer.valueOf((int)i))).intValue()] = l;
            }
            ++i;
        }
        out.writeTo(FILE);
        ColumnFileReader in = new ColumnFileReader(FILE);
        ColumnValues v = in.getValues("test");
        int i2 = 0;
        while (i2 < seekCount) {
            v.seek(seekRows[i2]);
            Assert.assertEquals((Object)seekValues[i2], (Object)v.next());
            ++i2;
        }
    }

    @Test
    public void testSeekStrings() throws Exception {
        FILE.delete();
        ColumnFileWriter out = new ColumnFileWriter(this.createFileMeta(), new ColumnMetaData("test", ValueType.STRING).hasIndexValues(true));
        Random random = TestUtil.createRandom();
        int seekCount = 64;
        HashMap<Integer, Integer> seekRowMap = new HashMap<Integer, Integer>(seekCount);
        while (seekRowMap.size() < seekCount) {
            int row = random.nextInt(65536);
            if (seekRowMap.containsKey(row)) continue;
            seekRowMap.put(row, seekRowMap.size());
        }
        Object[] values = new String[65536];
        int i = 0;
        while (i < 65536) {
            values[i] = TestUtil.randomString(random);
            ++i;
        }
        Arrays.sort(values);
        String[] seekValues = new String[seekCount];
        int i2 = 0;
        while (i2 < 65536) {
            out.writeRow(values[i2]);
            if (seekRowMap.containsKey(i2)) {
                seekValues[((Integer)seekRowMap.get((Object)Integer.valueOf((int)i2))).intValue()] = values[i2];
            }
            ++i2;
        }
        out.writeTo(FILE);
        ColumnFileReader in = new ColumnFileReader(FILE);
        ColumnValues<String> v = in.getValues("test");
        int i3 = 0;
        while (i3 < seekCount) {
            v.seek(seekValues[i3]);
            Assert.assertEquals((Object)seekValues[i3], (Object)v.next());
            ++i3;
        }
    }
}

