/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.trevni.avro.AvroColumnReader;
import org.apache.trevni.avro.HadoopInput;

public class AvroTrevniInputFormat<T>
extends FileInputFormat<AvroWrapper<T>, NullWritable> {
    @Override
    protected boolean isSplitable(FileSystem fs, Path filename) {
        return false;
    }

    @Override
    protected FileStatus[] listStatus(JobConf job) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        job.setBoolean("mapred.input.dir.recursive", true);
        FileStatus[] fileStatusArray = super.listStatus(job);
        int n = fileStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileStatus file = fileStatusArray[n2];
            if (file.getPath().getName().endsWith(".trv")) {
                result.add(file);
            }
            ++n2;
        }
        return result.toArray(new FileStatus[0]);
    }

    @Override
    public RecordReader<AvroWrapper<T>, NullWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        FileSplit file = (FileSplit)split;
        reporter.setStatus(file.toString());
        AvroColumnReader.Params params = new AvroColumnReader.Params(new HadoopInput(file.getPath(), job));
        params.setModel(ReflectData.get());
        if (job.get("avro.input.schema") != null) {
            params.setSchema(AvroJob.getInputSchema(job));
        }
        return new RecordReader<AvroWrapper<T>, NullWritable>(params){
            private AvroColumnReader<T> reader;
            private float rows;
            private long row;
            {
                this.reader = new AvroColumnReader(params);
                this.rows = this.reader.getRowCount();
            }

            @Override
            public AvroWrapper<T> createKey() {
                return new AvroWrapper<Object>(null);
            }

            @Override
            public NullWritable createValue() {
                return NullWritable.get();
            }

            @Override
            public boolean next(AvroWrapper<T> wrapper, NullWritable ignore) throws IOException {
                if (!this.reader.hasNext()) {
                    return false;
                }
                wrapper.datum(this.reader.next());
                ++this.row;
                return true;
            }

            @Override
            public float getProgress() throws IOException {
                return (float)this.row / this.rows;
            }

            @Override
            public long getPos() throws IOException {
                return this.row;
            }

            @Override
            public void close() throws IOException {
                this.reader.close();
            }
        };
    }
}

