/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.idl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.idl.IdlConstants;
import org.apache.avro.compiler.idl.IdlTokenManager;
import org.apache.avro.compiler.idl.JavaCharStream;
import org.apache.avro.compiler.idl.ParseException;
import org.apache.avro.compiler.idl.SchemaResolver;
import org.apache.avro.compiler.idl.Token;
import org.apache.avro.util.internal.Accessor;
import org.apache.commons.lang3.StringEscapeUtils;

public class Idl
implements Closeable,
IdlConstants {
    static JsonNodeFactory FACTORY = JsonNodeFactory.instance;
    File inputDir = new File(".");
    ClassLoader resourceLoader = null;
    String namespace;
    Map<String, Schema> names = new LinkedHashMap<String, Schema>();
    private static final ThreadLocal<String> DOC = new ThreadLocal();
    public IdlTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[38];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[3];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    static void setDoc(String doc) {
        DOC.set(doc.trim());
    }

    static String getDoc() {
        String doc = DOC.get();
        DOC.set(null);
        return doc;
    }

    public Idl(File inputFile) throws IOException {
        this(new FileInputStream(inputFile), "UTF-8");
        this.inputDir = inputFile.getParentFile();
    }

    public Idl(File inputFile, ClassLoader resourceLoader) throws IOException {
        this(inputFile);
        this.resourceLoader = resourceLoader;
    }

    private Idl(URL input, Idl parent) throws IOException {
        this(input.openStream(), "UTF-8");
        this.inputDir = "file".equals(input.getProtocol()) ? new File(input.getPath()).getParentFile() : parent.inputDir;
        this.resourceLoader = parent.resourceLoader;
    }

    @Override
    public void close() throws IOException {
        this.jj_input_stream.inputStream.close();
    }

    private ParseException error(String message, Token token) {
        return new ParseException(message + ", at line " + token.beginLine + ", column " + token.beginColumn);
    }

    private String getTextProp(String key, Map<String, JsonNode> props, Token token) throws ParseException {
        JsonNode value = props.get(key);
        if (value.isTextual()) {
            return value.textValue();
        }
        throw this.error(key + " property must be textual: " + value, token);
    }

    private List<String> getTextProps(String key, Map<String, JsonNode> props, Token token) throws ParseException {
        JsonNode value = props.get(key);
        if (!value.isArray()) {
            throw this.error(key + " property must be array: " + value, token);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (JsonNode n : value) {
            if (n.isTextual()) {
                values.add(n.textValue());
                continue;
            }
            throw this.error(key + " values must be textual: " + n, token);
        }
        return values;
    }

    private URL findFile(String importFile) throws IOException {
        File file = new File(this.inputDir, importFile);
        URL result = null;
        if (file.exists()) {
            result = file.toURL();
        } else if (this.resourceLoader != null) {
            result = this.resourceLoader.getResource(importFile);
        }
        if (result == null) {
            throw new FileNotFoundException(importFile);
        }
        return result;
    }

    public final Protocol CompilationUnit() throws ParseException {
        Protocol p = this.ProtocolDeclaration();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 71: {
                this.jj_consume_token(71);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        this.jj_consume_token(0);
        return SchemaResolver.resolve(p);
    }

    private final Schema NamedSchemaDeclaration(Map<String, JsonNode> props) throws ParseException {
        Schema s;
        String savedSpace = this.namespace;
        if (props.containsKey("namespace")) {
            this.namespace = this.getTextProp("namespace", props, this.token);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                s = this.FixedDeclaration();
                break;
            }
            case 15: {
                s = this.EnumDeclaration();
                break;
            }
            case 16: 
            case 31: {
                s = this.RecordDeclaration();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.namespace = savedSpace;
        for (String key : props.keySet()) {
            if ("namespace".equals(key)) continue;
            if ("aliases".equals(key)) {
                for (String alias : this.getTextProps("aliases", props, this.token)) {
                    s.addAlias(alias);
                }
                continue;
            }
            Accessor.addProp(s, key, props.get(key));
        }
        return s;
    }

    public final Schema UnionDefinition() throws ParseException {
        ArrayList<Schema> schemata = new ArrayList<Schema>();
        this.jj_consume_token(34);
        this.jj_consume_token(57);
        Schema s = this.Type();
        schemata.add(s);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 63: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(63);
            s = this.Type();
            schemata.add(s);
        }
        this.jj_consume_token(58);
        return Schema.createUnion(schemata);
    }

    public final Protocol ProtocolDeclaration() throws ParseException {
        LinkedHashMap<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 64: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            this.SchemaProperty(props);
        }
        if (props.containsKey("namespace")) {
            this.namespace = this.getTextProp("namespace", props, this.token);
        }
        this.jj_consume_token(30);
        String name = this.Identifier();
        Protocol p = new Protocol(name, Idl.getDoc(), this.namespace);
        for (String key : props.keySet()) {
            if ("namespace".equals(key)) continue;
            Accessor.addProp(p, key, (JsonNode)props.get(key));
        }
        this.ProtocolBody(p);
        return p;
    }

    public final Schema EnumDeclaration() throws ParseException {
        String defaultSymbol = null;
        this.jj_consume_token(15);
        String doc = Idl.getDoc();
        String name = this.Identifier();
        List<String> symbols = this.EnumBody();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 65: {
                this.jj_consume_token(65);
                defaultSymbol = this.Identifier();
                this.jj_consume_token(62);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        Schema s = Schema.createEnum(name, doc, this.namespace, symbols, defaultSymbol);
        this.names.put(s.getFullName(), s);
        return s;
    }

    public final List<String> EnumBody() throws ParseException {
        ArrayList<String> symbols = new ArrayList<String>();
        this.jj_consume_token(57);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 52: 
            case 70: {
                this.EnumConstant(symbols);
                while (this.jj_2_1(2)) {
                    this.jj_consume_token(63);
                    this.EnumConstant(symbols);
                }
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        this.jj_consume_token(58);
        return symbols;
    }

    public final void EnumConstant(List<String> symbols) throws ParseException {
        String sym = this.Identifier();
        symbols.add(sym);
    }

    public final void ProtocolBody(Protocol p) throws ParseException {
        block25: {
            LinkedHashMap<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
            this.jj_consume_token(57);
            block22: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 19: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 26: 
                    case 28: 
                    case 29: 
                    case 31: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 52: 
                    case 64: 
                    case 70: {
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        break block25;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        Schema schema;
                        this.jj_consume_token(21);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 20: 
                            case 30: {
                                Protocol importProtocol;
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 20: {
                                        importProtocol = this.ImportIdl();
                                        break;
                                    }
                                    case 30: {
                                        importProtocol = this.ImportProtocol();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[8] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                for (Schema s : importProtocol.getTypes()) {
                                    this.names.put(s.getFullName(), s);
                                }
                                p.getMessages().putAll(importProtocol.getMessages());
                                continue block22;
                            }
                            case 27: {
                                schema = this.ImportSchema();
                                continue block22;
                            }
                        }
                        this.jj_la1[9] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 19: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 26: 
                    case 28: 
                    case 29: 
                    case 31: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 52: 
                    case 64: 
                    case 70: {
                        Schema schema;
                        block24: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 64: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[10] = this.jj_gen;
                                    break block24;
                                }
                            }
                            this.SchemaProperty(props);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 15: 
                            case 16: 
                            case 18: 
                            case 31: {
                                schema = this.NamedSchemaDeclaration(props);
                                break;
                            }
                            case 12: 
                            case 13: 
                            case 14: 
                            case 19: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 26: 
                            case 28: 
                            case 29: 
                            case 34: 
                            case 35: 
                            case 36: 
                            case 37: 
                            case 38: 
                            case 39: 
                            case 40: 
                            case 52: 
                            case 64: 
                            case 70: {
                                Protocol.Message message = this.MessageDeclaration(p, props);
                                p.getMessages().put(message.getName(), message);
                                break;
                            }
                            default: {
                                this.jj_la1[11] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        props.clear();
                        continue block22;
                    }
                }
                break;
            }
            this.jj_la1[12] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(58);
        p.setTypes(this.names.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Protocol ImportIdl() throws ParseException {
        Protocol protocol;
        this.jj_consume_token(20);
        String importFile = this.JsonString();
        this.jj_consume_token(62);
        Idl idl = new Idl(this.findFile(importFile), this);
        try {
            protocol = idl.CompilationUnit();
        }
        catch (Throwable throwable) {
            try {
                idl.close();
                throw throwable;
            }
            catch (IOException e) {
                throw this.error("Error importing " + importFile + ": " + e, this.token);
            }
        }
        idl.close();
        return protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Protocol ImportProtocol() throws ParseException {
        Protocol protocol;
        this.jj_consume_token(30);
        String importFile = this.JsonString();
        this.jj_consume_token(62);
        InputStream stream = this.findFile(importFile).openStream();
        try {
            protocol = Protocol.parse(stream);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw this.error("Error importing " + importFile + ": " + e, this.token);
            }
        }
        stream.close();
        return protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Schema ImportSchema() throws ParseException {
        Schema schema;
        this.jj_consume_token(27);
        String importFile = this.JsonString();
        this.jj_consume_token(62);
        Schema.Parser parser = new Schema.Parser();
        parser.addTypes(this.names);
        InputStream stream = this.findFile(importFile).openStream();
        try {
            Schema value = parser.parse(stream);
            this.names = parser.getTypes();
            schema = value;
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw this.error("Error importing " + importFile + ": " + e, this.token);
            }
        }
        stream.close();
        return schema;
    }

    public final Schema FixedDeclaration() throws ParseException {
        this.jj_consume_token(18);
        String name = this.Identifier();
        this.jj_consume_token(55);
        Token sizeTok = this.jj_consume_token(41);
        this.jj_consume_token(56);
        this.jj_consume_token(62);
        Schema s = Schema.createFixed(name, Idl.getDoc(), this.namespace, Integer.parseInt(sizeTok.image));
        this.names.put(s.getFullName(), s);
        return s;
    }

    public final Schema RecordDeclaration() throws ParseException {
        boolean isError;
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                isError = false;
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                isError = true;
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String name = this.Identifier();
        Schema result = Schema.createRecord(name, Idl.getDoc(), this.namespace, isError);
        this.names.put(result.getFullName(), result);
        this.jj_consume_token(57);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: 
                case 13: 
                case 14: 
                case 19: 
                case 22: 
                case 23: 
                case 24: 
                case 26: 
                case 28: 
                case 29: 
                case 34: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 52: 
                case 64: 
                case 70: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block7;
                }
            }
            this.FieldDeclaration(fields);
        }
        this.jj_consume_token(58);
        result.setFields(fields);
        return result;
    }

    private final void SchemaProperty(Map<String, JsonNode> properties) throws ParseException {
        this.jj_consume_token(64);
        String key = this.PropertyName();
        this.jj_consume_token(55);
        JsonNode val = this.Json();
        this.jj_consume_token(56);
        if (properties.containsKey(key)) {
            throw this.error("Property '" + key + "' already specified", this.token);
        }
        properties.put(key, val);
    }

    public final void FieldDeclaration(List<Schema.Field> fields) throws ParseException {
        LinkedHashMap<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 64: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block6;
                }
            }
            this.SchemaProperty(props);
        }
        Schema type = this.Type();
        this.VariableDeclarator(type, fields);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 63: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(63);
            this.VariableDeclarator(type, fields);
        }
        this.jj_consume_token(62);
        for (String key : props.keySet()) {
            Accessor.addProp(type, key, (JsonNode)props.get(key));
        }
    }

    public final void VariableDeclarator(Schema type, List<Schema.Field> fields) throws ParseException {
        JsonNode defaultValue = null;
        LinkedHashMap<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 64: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block6;
                }
            }
            this.SchemaProperty(props);
        }
        String name = this.Identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 65: {
                this.jj_consume_token(65);
                defaultValue = this.Json();
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        Schema.Field.Order order = Schema.Field.Order.ASCENDING;
        for (String key : props.keySet()) {
            if (!"order".equals(key)) continue;
            order = Schema.Field.Order.valueOf(this.getTextProp(key, props, this.token).toUpperCase());
        }
        boolean validate = !SchemaResolver.isUnresolvedSchema(type);
        Schema.Field field = Accessor.createField(name, type, Idl.getDoc(), defaultValue, validate, order);
        for (String key : props.keySet()) {
            if ("order".equals(key)) continue;
            if ("aliases".equals(key)) {
                for (String alias : this.getTextProps("aliases", props, this.token)) {
                    field.addAlias(alias);
                }
                continue;
            }
            Accessor.addProp(field, key, (JsonNode)props.get(key));
        }
        fields.add(field);
    }

    public final String MessageDocumentation() throws ParseException {
        return Idl.getDoc();
    }

    private final Protocol.Message MessageDeclaration(Protocol p, Map<String, JsonNode> props) throws ParseException {
        boolean oneWay = false;
        ArrayList<Schema> errorSchemata = new ArrayList<Schema>();
        errorSchemata.add(Protocol.SYSTEM_ERROR);
        String msgDoc = this.MessageDocumentation();
        Schema response = this.ResultType();
        String name = this.Identifier();
        Schema request = this.FormalParameters();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: 
            case 32: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 25: {
                        this.jj_consume_token(25);
                        oneWay = true;
                        break block0;
                    }
                    case 32: {
                        this.jj_consume_token(32);
                        this.ErrorList(errorSchemata);
                        break block0;
                    }
                }
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        this.jj_consume_token(62);
        Schema errors = Schema.createUnion(errorSchemata);
        if (oneWay && response.getType() != Schema.Type.NULL) {
            throw this.error("One-way message'" + name + "' must return void", this.token);
        }
        return oneWay ? p.createMessage(name, msgDoc, props, request) : p.createMessage(name, msgDoc, props, request, response, errors);
    }

    public final void ErrorList(List<Schema> errors) throws ParseException {
        Schema s = this.ReferenceType();
        errors.add(s);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 63: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(63);
            s = this.ReferenceType();
            errors.add(s);
        }
    }

    public final Schema FormalParameters() throws ParseException {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        this.jj_consume_token(55);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 52: 
            case 64: 
            case 70: {
                this.FormalParameter(fields);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 63: {
                            break;
                        }
                        default: {
                            this.jj_la1[22] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(63);
                    this.FormalParameter(fields);
                }
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        this.jj_consume_token(56);
        return Schema.createRecord(fields);
    }

    public final void FormalParameter(List<Schema.Field> fields) throws ParseException {
        Schema type = this.Type();
        this.VariableDeclarator(type, fields);
    }

    public final Schema Type() throws ParseException {
        Schema s;
        LinkedHashMap<String, JsonNode> props = new LinkedHashMap<String, JsonNode>();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 64: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block9;
                }
            }
            this.SchemaProperty(props);
        }
        if (this.jj_2_2(2)) {
            s = this.ReferenceType();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 14: 
                case 19: 
                case 22: 
                case 23: 
                case 26: 
                case 28: 
                case 29: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    s = this.PrimitiveType();
                    break;
                }
                case 34: {
                    s = this.UnionDefinition();
                    break;
                }
                case 12: {
                    s = this.ArrayType();
                    break;
                }
                case 24: {
                    s = this.MapType();
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        for (String key : props.keySet()) {
            Accessor.addProp(s, key, (JsonNode)props.get(key));
        }
        return s;
    }

    public final Schema ArrayType() throws ParseException {
        this.jj_consume_token(12);
        this.jj_consume_token(68);
        Schema elemSchema = this.Type();
        this.jj_consume_token(69);
        return Schema.createArray(elemSchema);
    }

    public final Schema MapType() throws ParseException {
        this.jj_consume_token(24);
        this.jj_consume_token(68);
        Schema elemSchema = this.Type();
        this.jj_consume_token(69);
        return Schema.createMap(elemSchema);
    }

    public final Schema ReferenceType() throws ParseException {
        Schema type;
        StringBuilder sb = new StringBuilder();
        String part = this.Identifier();
        sb.append(part);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: {
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(66);
            Token tok = this.AnyIdentifier();
            sb.append(".").append(tok.image);
        }
        String name = sb.toString();
        if (name.indexOf(46) == -1 && this.namespace != null) {
            name = this.namespace + "." + name;
        }
        if ((type = this.names.get(name)) == null) {
            type = SchemaResolver.unresolvedSchema(name);
        }
        return type;
    }

    public final Schema PrimitiveType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                return Schema.create(Schema.Type.BOOLEAN);
            }
            case 26: {
                this.jj_consume_token(26);
                return Schema.create(Schema.Type.BYTES);
            }
            case 22: {
                this.jj_consume_token(22);
                return Schema.create(Schema.Type.INT);
            }
            case 28: {
                this.jj_consume_token(28);
                return Schema.create(Schema.Type.STRING);
            }
            case 19: {
                this.jj_consume_token(19);
                return Schema.create(Schema.Type.FLOAT);
            }
            case 14: {
                this.jj_consume_token(14);
                return Schema.create(Schema.Type.DOUBLE);
            }
            case 23: {
                this.jj_consume_token(23);
                return Schema.create(Schema.Type.LONG);
            }
            case 29: {
                this.jj_consume_token(29);
                return Schema.create(Schema.Type.NULL);
            }
            case 36: {
                this.jj_consume_token(36);
                return LogicalTypes.date().addToSchema(Schema.create(Schema.Type.INT));
            }
            case 37: {
                this.jj_consume_token(37);
                return LogicalTypes.timeMillis().addToSchema(Schema.create(Schema.Type.INT));
            }
            case 38: {
                this.jj_consume_token(38);
                return LogicalTypes.timestampMillis().addToSchema(Schema.create(Schema.Type.LONG));
            }
            case 40: {
                this.jj_consume_token(40);
                return LogicalTypes.localTimestampMillis().addToSchema(Schema.create(Schema.Type.LONG));
            }
            case 39: {
                this.jj_consume_token(39);
                return this.DecimalTypeProperties();
            }
        }
        this.jj_la1[27] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Schema DecimalTypeProperties() throws ParseException {
        this.jj_consume_token(55);
        int precision = this.Json().asInt();
        this.jj_consume_token(63);
        int scale = this.Json().asInt();
        this.jj_consume_token(56);
        return LogicalTypes.decimal(precision, scale).addToSchema(Schema.create(Schema.Type.BYTES));
    }

    public final Schema ResultType() throws ParseException {
        if (this.jj_2_3(2)) {
            this.jj_consume_token(35);
            return Schema.create(Schema.Type.NULL);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 52: 
            case 64: 
            case 70: {
                Schema schema = this.Type();
                return schema;
            }
        }
        this.jj_la1[28] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String PropertyName() throws ParseException {
        StringBuffer name;
        block8: {
            name = new StringBuffer();
            Token t = this.jj_consume_token(52);
            name.append(t.image);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 66: 
                    case 67: {
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 67: {
                        t = this.jj_consume_token(67);
                        name.append(t.image);
                        t = this.jj_consume_token(52);
                        name.append(t.image);
                        continue block7;
                    }
                    case 66: {
                        t = this.jj_consume_token(66);
                        name.append(t.image);
                        t = this.jj_consume_token(52);
                        name.append(t.image);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[30] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return name.toString();
    }

    public final String Identifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 52: {
                Token t = this.jj_consume_token(52);
                return t.image;
            }
            case 70: {
                this.jj_consume_token(70);
                Token t = this.AnyIdentifier();
                this.jj_consume_token(70);
                return t.image;
            }
        }
        this.jj_la1[31] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Token AnyIdentifier() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                t = this.jj_consume_token(12);
                break;
            }
            case 13: {
                t = this.jj_consume_token(13);
                break;
            }
            case 14: {
                t = this.jj_consume_token(14);
                break;
            }
            case 15: {
                t = this.jj_consume_token(15);
                break;
            }
            case 16: {
                t = this.jj_consume_token(16);
                break;
            }
            case 17: {
                t = this.jj_consume_token(17);
                break;
            }
            case 18: {
                t = this.jj_consume_token(18);
                break;
            }
            case 19: {
                t = this.jj_consume_token(19);
                break;
            }
            case 22: {
                t = this.jj_consume_token(22);
                break;
            }
            case 23: {
                t = this.jj_consume_token(23);
                break;
            }
            case 24: {
                t = this.jj_consume_token(24);
                break;
            }
            case 26: {
                t = this.jj_consume_token(26);
                break;
            }
            case 28: {
                t = this.jj_consume_token(28);
                break;
            }
            case 30: {
                t = this.jj_consume_token(30);
                break;
            }
            case 31: {
                t = this.jj_consume_token(31);
                break;
            }
            case 27: {
                t = this.jj_consume_token(27);
                break;
            }
            case 32: {
                t = this.jj_consume_token(32);
                break;
            }
            case 33: {
                t = this.jj_consume_token(33);
                break;
            }
            case 34: {
                t = this.jj_consume_token(34);
                break;
            }
            case 35: {
                t = this.jj_consume_token(35);
                break;
            }
            case 36: {
                t = this.jj_consume_token(36);
                break;
            }
            case 37: {
                t = this.jj_consume_token(37);
                break;
            }
            case 38: {
                t = this.jj_consume_token(38);
                break;
            }
            case 40: {
                t = this.jj_consume_token(40);
                break;
            }
            case 39: {
                t = this.jj_consume_token(39);
                break;
            }
            case 52: {
                t = this.jj_consume_token(52);
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t;
    }

    private final JsonNode Json() throws ParseException {
        JsonNode n;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                String s = this.JsonString();
                n = new TextNode(s);
                break;
            }
            case 41: {
                Token t = this.jj_consume_token(41);
                n = new LongNode(Long.parseLong(t.image));
                break;
            }
            case 45: {
                Token t = this.jj_consume_token(45);
                n = new DoubleNode(Double.parseDouble(t.image));
                break;
            }
            case 57: {
                n = this.JsonObject();
                break;
            }
            case 59: {
                n = this.JsonArray();
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                n = BooleanNode.TRUE;
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                n = BooleanNode.FALSE;
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                n = NullNode.instance;
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final String JsonString() throws ParseException {
        Token t = this.jj_consume_token(51);
        String betweenQuotes = t.image.substring(1, t.image.length() - 1);
        return StringEscapeUtils.unescapeJava(betweenQuotes);
    }

    private final JsonNode JsonObject() throws ParseException {
        ObjectNode o = FACTORY.objectNode();
        this.jj_consume_token(57);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                this.JsonFields(o);
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
            }
        }
        this.jj_consume_token(58);
        return o;
    }

    private final void JsonFields(ObjectNode o) throws ParseException {
        this.JsonPair(o);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                this.jj_consume_token(63);
                this.JsonFields(o);
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
            }
        }
    }

    private final void JsonPair(ObjectNode o) throws ParseException {
        String name = this.JsonString();
        this.jj_consume_token(61);
        JsonNode value = this.Json();
        o.set(name, value);
    }

    private final JsonNode JsonArray() throws ParseException {
        ArrayNode a = FACTORY.arrayNode();
        this.jj_consume_token(59);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: 
            case 29: 
            case 33: 
            case 41: 
            case 45: 
            case 51: 
            case 57: 
            case 59: {
                this.JsonElements(a);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        this.jj_consume_token(60);
        return a;
    }

    private final void JsonElements(ArrayNode a) throws ParseException {
        JsonNode element = this.Json();
        a.add(element);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                this.jj_consume_token(63);
                this.JsonElements(a);
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    private boolean jj_3R_20() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        return this.jj_3R_21();
    }

    private boolean jj_3R_17() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_20()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_19() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_15() {
        return this.jj_3R_17();
    }

    private boolean jj_3_3() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3_2() {
        return this.jj_3R_16();
    }

    private boolean jj_3R_18() {
        return this.jj_scan_token(66);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private boolean jj_3R_21() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(12)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(13)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(14)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(15)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(16)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(17)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(18)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(19)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(22)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(23)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(24)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(26)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(28)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(30)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(31)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(27)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(32)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(33)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(34)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(35)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(36)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(37)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(38)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(40)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(39)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(52)) {
                                                                                                                return true;
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_16() {
        Token xsp;
        if (this.jj_3R_17()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_18());
        this.jj_scanpos = xsp;
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, -2147123200, 0, 0, 0, 0, -1242697728, 0x40100000, 1209008128, 0, -1244794880, -1242697728, -2147418112, 902328320, 0, 0, 0, 0, 0x2000000, 0x2000000, 0, 0, 902328320, 0, 902328320, 0, 885547008, 902328320, 0, 0, 0, -573575168, 0x20020000, 0, 0, 0x20020000, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, Integer.MIN_VALUE, 0, 0, 0x100000, 1049084, 0, 0, 0, 1049084, 1049084, 0, 1049076, 0, Integer.MIN_VALUE, 0, 0, 1, 1, Integer.MIN_VALUE, Integer.MIN_VALUE, 1049076, 0, 500, 0, 496, 1049076, 0, 0, 0x100000, 0x1001FF, 168305154, 524288, Integer.MIN_VALUE, 168305154, Integer.MIN_VALUE};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{128, 256, 0, 0, 1, 2, 64, 65, 0, 0, 1, 65, 65, 0, 65, 1, 0, 1, 2, 0, 0, 0, 0, 65, 1, 0, 4, 0, 65, 12, 12, 64, 0, 0, 0, 0, 0, 0};
    }

    public Idl(InputStream stream) {
        this(stream, null);
    }

    public Idl(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new IdlTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 38; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 38; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Idl(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new IdlTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 38; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 38; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Idl(IdlTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 38; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(IdlTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 38; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[73];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 38; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 73; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 3; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        Idl.jj_la1_init_0();
        Idl.jj_la1_init_1();
        Idl.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

