/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.trevni.Codec;

public class BZip2Codec
extends Codec {
    private ByteArrayOutputStream outputBuffer;
    public static final int DEFAULT_BUFFER_SIZE = 65536;

    @Override
    ByteBuffer compress(ByteBuffer uncompressedData) throws IOException {
        ByteArrayOutputStream baos = this.getOutputBuffer(uncompressedData.remaining());
        Throwable throwable = null;
        Object var4_5 = null;
        try (BZip2CompressorOutputStream outputStream = new BZip2CompressorOutputStream(baos);){
            outputStream.write(uncompressedData.array());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ByteBuffer result = ByteBuffer.wrap(baos.toByteArray());
        return result;
    }

    @Override
    ByteBuffer decompress(ByteBuffer compressedData) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(compressedData.array());
        Throwable throwable = null;
        Object var4_5 = null;
        try (BZip2CompressorInputStream inputStream = new BZip2CompressorInputStream(bais);){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[65536];
            int readCount = -1;
            while ((readCount = inputStream.read(buffer, compressedData.position(), buffer.length)) > 0) {
                baos.write(buffer, 0, readCount);
            }
            ByteBuffer result = ByteBuffer.wrap(baos.toByteArray());
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ByteArrayOutputStream getOutputBuffer(int suggestedLength) {
        if (this.outputBuffer == null) {
            this.outputBuffer = new ByteArrayOutputStream(suggestedLength);
        }
        this.outputBuffer.reset();
        return this.outputBuffer;
    }
}

