/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import org.apache.trevni.Codec;

class DeflateCodec
extends Codec {
    private ByteArrayOutputStream outputBuffer;
    private Deflater deflater;
    private Inflater inflater;

    DeflateCodec() {
    }

    @Override
    ByteBuffer compress(ByteBuffer data) throws IOException {
        ByteArrayOutputStream baos = this.getOutputBuffer(data.remaining());
        this.writeAndClose(data, new DeflaterOutputStream((OutputStream)baos, this.getDeflater()));
        return ByteBuffer.wrap(baos.toByteArray());
    }

    @Override
    ByteBuffer decompress(ByteBuffer data) throws IOException {
        ByteArrayOutputStream baos = this.getOutputBuffer(data.remaining());
        this.writeAndClose(data, new InflaterOutputStream(baos, this.getInflater()));
        return ByteBuffer.wrap(baos.toByteArray());
    }

    private void writeAndClose(ByteBuffer data, OutputStream out) throws IOException {
        out.write(data.array(), data.position(), data.remaining());
        out.close();
    }

    private Inflater getInflater() {
        if (this.inflater == null) {
            this.inflater = new Inflater(true);
        }
        this.inflater.reset();
        return this.inflater;
    }

    private Deflater getDeflater() {
        if (this.deflater == null) {
            this.deflater = new Deflater(-1, true);
        }
        this.deflater.reset();
        return this.deflater;
    }

    private ByteArrayOutputStream getOutputBuffer(int suggestedLength) {
        if (this.outputBuffer == null) {
            this.outputBuffer = new ByteArrayOutputStream(suggestedLength);
        }
        this.outputBuffer.reset();
        return this.outputBuffer;
    }
}

