/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.apache.trevni.InputBuffer;
import org.apache.trevni.InputBytes;
import org.apache.trevni.OutputBuffer;
import org.apache.trevni.TestUtil;
import org.apache.trevni.ValueType;
import org.junit.Assert;
import org.junit.Test;

public class TestIOBuffers {
    private static final int COUNT = 1001;

    @Test
    public void testEmpty() throws Exception {
        OutputBuffer out = new OutputBuffer();
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        Assert.assertEquals((long)0L, (long)in.tell());
        Assert.assertEquals((long)0L, (long)in.length());
    }

    @Test
    public void testZero() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        out.writeInt(0);
        byte[] bytes = out.toByteArray();
        Assert.assertEquals((long)1L, (long)bytes.length);
        Assert.assertEquals((long)0L, (long)bytes[0]);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        Assert.assertEquals((long)0L, (long)in.readInt());
    }

    @Test
    public void testBoolean() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        int i = 0;
        while (i < 1001) {
            out.writeValue(random.nextBoolean(), ValueType.BOOLEAN);
            ++i;
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        random = TestUtil.createRandom();
        int i2 = 0;
        while (i2 < 1001) {
            Assert.assertEquals((Object)random.nextBoolean(), in.readValue(ValueType.BOOLEAN));
            ++i2;
        }
    }

    @Test
    public void testInt() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        int i = 0;
        while (i < 1001) {
            out.writeInt(random.nextInt());
            ++i;
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        random = TestUtil.createRandom();
        int i2 = 0;
        while (i2 < 1001) {
            Assert.assertEquals((long)random.nextInt(), (long)in.readInt());
            ++i2;
        }
    }

    @Test
    public void testLong() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        int i = 0;
        while (i < 1001) {
            out.writeLong(random.nextLong());
            ++i;
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        random = TestUtil.createRandom();
        int i2 = 0;
        while (i2 < 1001) {
            Assert.assertEquals((long)random.nextLong(), (long)in.readLong());
            ++i2;
        }
    }

    @Test
    public void testFixed32() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        int i = 0;
        while (i < 1001) {
            out.writeFixed32(random.nextInt());
            ++i;
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        random = TestUtil.createRandom();
        int i2 = 0;
        while (i2 < 1001) {
            Assert.assertEquals((long)random.nextInt(), (long)in.readFixed32());
            ++i2;
        }
    }

    @Test
    public void testFixed64() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        int i = 0;
        while (i < 1001) {
            out.writeFixed64(random.nextLong());
            ++i;
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        random = TestUtil.createRandom();
        int i2 = 0;
        while (i2 < 1001) {
            Assert.assertEquals((long)random.nextLong(), (long)in.readFixed64());
            ++i2;
        }
    }

    @Test
    public void testFloat() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        int i = 0;
        while (i < 1001) {
            out.writeFloat(random.nextFloat());
            ++i;
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        random = TestUtil.createRandom();
        int i2 = 0;
        while (i2 < 1001) {
            Assert.assertEquals((float)random.nextFloat(), (float)in.readFloat(), (float)0.0f);
            ++i2;
        }
    }

    @Test
    public void testDouble() throws Exception {
        OutputBuffer out = new OutputBuffer();
        int i = 0;
        while (i < 1001) {
            out.writeDouble(Double.MIN_VALUE);
            ++i;
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        int i2 = 0;
        while (i2 < 1001) {
            Assert.assertEquals((double)Double.MIN_VALUE, (double)in.readDouble(), (double)0.0);
            ++i2;
        }
    }

    @Test
    public void testBytes() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        int i = 0;
        while (i < 1001) {
            out.writeBytes(TestUtil.randomBytes(random));
            ++i;
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        random = TestUtil.createRandom();
        int i2 = 0;
        while (i2 < 1001) {
            Assert.assertEquals((Object)TestUtil.randomBytes(random), (Object)in.readBytes(null));
            ++i2;
        }
    }

    @Test
    public void testString() throws Exception {
        Random random = TestUtil.createRandom();
        OutputBuffer out = new OutputBuffer();
        int i = 0;
        while (i < 1001) {
            out.writeString(TestUtil.randomString(random));
            ++i;
        }
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        random = TestUtil.createRandom();
        int i2 = 0;
        while (i2 < 1001) {
            Assert.assertEquals((Object)TestUtil.randomString(random), (Object)in.readString());
            ++i2;
        }
    }

    @Test
    public void testSkipNull() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(null, ValueType.NULL);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.NULL);
        Assert.assertEquals((long)sentinel, (long)in.readLong());
    }

    @Test
    public void testSkipBoolean() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(false, ValueType.BOOLEAN);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.BOOLEAN);
        Assert.assertEquals((long)sentinel, (long)in.readLong());
    }

    @Test
    public void testSkipInt() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(Integer.MAX_VALUE, ValueType.INT);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.INT);
        Assert.assertEquals((long)sentinel, (long)in.readLong());
    }

    @Test
    public void testSkipLong() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(Long.MAX_VALUE, ValueType.LONG);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.LONG);
        Assert.assertEquals((long)sentinel, (long)in.readLong());
    }

    @Test
    public void testSkipFixed32() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(Integer.MAX_VALUE, ValueType.FIXED32);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.LONG);
        Assert.assertEquals((long)sentinel, (long)in.readLong());
    }

    @Test
    public void testSkipFixed64() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(Long.MAX_VALUE, ValueType.FIXED64);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.LONG);
        Assert.assertEquals((long)sentinel, (long)in.readLong());
    }

    @Test
    public void testSkipFloat() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(Float.valueOf(Float.MAX_VALUE), ValueType.FLOAT);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.FLOAT);
        Assert.assertEquals((long)sentinel, (long)in.readLong());
    }

    @Test
    public void testSkipDouble() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(Double.MAX_VALUE, ValueType.DOUBLE);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.DOUBLE);
        Assert.assertEquals((long)sentinel, (long)in.readLong());
    }

    @Test
    public void testSkipString() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue("trevni", ValueType.STRING);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.STRING);
        Assert.assertEquals((long)sentinel, (long)in.readLong());
    }

    @Test
    public void testSkipBytes() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue("trevni".getBytes(StandardCharsets.UTF_8), ValueType.BYTES);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.skipValue(ValueType.BYTES);
        Assert.assertEquals((long)sentinel, (long)in.readLong());
    }

    @Test
    public void testInitPos() throws Exception {
        long sentinel = Long.MAX_VALUE;
        OutputBuffer out = new OutputBuffer();
        out.writeValue(Integer.MAX_VALUE, ValueType.INT);
        out.writeLong(sentinel);
        InputBuffer in = new InputBuffer(new InputBytes(out.toByteArray()));
        in.readInt();
        long pos = in.tell();
        in = new InputBuffer(new InputBytes(out.toByteArray()), pos);
        Assert.assertEquals((long)sentinel, (long)in.readLong());
    }
}

