/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tracing;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.tracing.SpanReceiverInfo;
import org.apache.hadoop.tracing.SpanReceiverInfoBuilder;
import org.apache.hadoop.tracing.TraceAdminPB;
import org.apache.hadoop.tracing.TraceAdminProtocol;
import org.apache.hadoop.tracing.TraceAdminProtocolPB;

@InterfaceAudience.Private
public class TraceAdminProtocolServerSideTranslatorPB
implements TraceAdminProtocolPB,
Closeable {
    private final TraceAdminProtocol server;

    public TraceAdminProtocolServerSideTranslatorPB(TraceAdminProtocol server) {
        this.server = server;
    }

    @Override
    public void close() throws IOException {
        RPC.stopProxy(this.server);
    }

    @Override
    public TraceAdminPB.ListSpanReceiversResponseProto listSpanReceivers(RpcController controller, TraceAdminPB.ListSpanReceiversRequestProto req) throws ServiceException {
        try {
            SpanReceiverInfo[] descs = this.server.listSpanReceivers();
            TraceAdminPB.ListSpanReceiversResponseProto.Builder bld = TraceAdminPB.ListSpanReceiversResponseProto.newBuilder();
            for (int i = 0; i < descs.length; ++i) {
                bld.addDescriptions(TraceAdminPB.SpanReceiverListInfo.newBuilder().setId(descs[i].getId()).setClassName(descs[i].getClassName()).build());
            }
            return bld.build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public TraceAdminPB.AddSpanReceiverResponseProto addSpanReceiver(RpcController controller, TraceAdminPB.AddSpanReceiverRequestProto req) throws ServiceException {
        try {
            SpanReceiverInfoBuilder factory = new SpanReceiverInfoBuilder(req.getClassName());
            for (TraceAdminPB.ConfigPair config : req.getConfigList()) {
                factory.addConfigurationPair(config.getKey(), config.getValue());
            }
            long id = this.server.addSpanReceiver(factory.build());
            return TraceAdminPB.AddSpanReceiverResponseProto.newBuilder().setId(id).build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public TraceAdminPB.RemoveSpanReceiverResponseProto removeSpanReceiver(RpcController controller, TraceAdminPB.RemoveSpanReceiverRequestProto req) throws ServiceException {
        try {
            this.server.removeSpanReceiver(req.getId());
            return TraceAdminPB.RemoveSpanReceiverResponseProto.getDefaultInstance();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        return 1L;
    }

    @Override
    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        if (!protocol.equals(RPC.getProtocolName(TraceAdminProtocolPB.class))) {
            throw new IOException("Serverside implements " + RPC.getProtocolName(TraceAdminProtocolPB.class) + ". The following requested protocol is unknown: " + protocol);
        }
        return ProtocolSignature.getProtocolSignature(clientMethodsHash, RPC.getProtocolVersion(TraceAdminProtocolPB.class), TraceAdminProtocolPB.class);
    }
}

