/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.protobuf.TextFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationReportPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class QueueInfoPBImpl
extends QueueInfo {
    YarnProtos.QueueInfoProto proto = YarnProtos.QueueInfoProto.getDefaultInstance();
    YarnProtos.QueueInfoProto.Builder builder = null;
    boolean viaProto = false;
    List<ApplicationReport> applicationsList;
    List<QueueInfo> childQueuesList;
    Set<String> accessibleNodeLabels;

    public QueueInfoPBImpl() {
        this.builder = YarnProtos.QueueInfoProto.newBuilder();
    }

    public QueueInfoPBImpl(YarnProtos.QueueInfoProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    @Override
    public List<ApplicationReport> getApplications() {
        this.initLocalApplicationsList();
        return this.applicationsList;
    }

    @Override
    public float getCapacity() {
        YarnProtos.QueueInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasCapacity() ? p.getCapacity() : -1.0f;
    }

    @Override
    public List<QueueInfo> getChildQueues() {
        this.initLocalChildQueuesList();
        return this.childQueuesList;
    }

    @Override
    public float getCurrentCapacity() {
        YarnProtos.QueueInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasCurrentCapacity() ? p.getCurrentCapacity() : 0.0f;
    }

    @Override
    public float getMaximumCapacity() {
        YarnProtos.QueueInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasMaximumCapacity() ? p.getMaximumCapacity() : -1.0f;
    }

    @Override
    public String getQueueName() {
        YarnProtos.QueueInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasQueueName() ? p.getQueueName() : null;
    }

    @Override
    public QueueState getQueueState() {
        YarnProtos.QueueInfoProtoOrBuilder p;
        YarnProtos.QueueInfoProtoOrBuilder queueInfoProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasState()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getState());
    }

    @Override
    public void setApplications(List<ApplicationReport> applications) {
        if (applications == null) {
            this.builder.clearApplications();
        }
        this.applicationsList = applications;
    }

    @Override
    public void setCapacity(float capacity) {
        this.maybeInitBuilder();
        this.builder.setCapacity(capacity);
    }

    @Override
    public void setChildQueues(List<QueueInfo> childQueues) {
        if (childQueues == null) {
            this.builder.clearChildQueues();
        }
        this.childQueuesList = childQueues;
    }

    @Override
    public void setCurrentCapacity(float currentCapacity) {
        this.maybeInitBuilder();
        this.builder.setCurrentCapacity(currentCapacity);
    }

    @Override
    public void setMaximumCapacity(float maximumCapacity) {
        this.maybeInitBuilder();
        this.builder.setMaximumCapacity(maximumCapacity);
    }

    @Override
    public void setQueueName(String queueName) {
        this.maybeInitBuilder();
        if (queueName == null) {
            this.builder.clearQueueName();
            return;
        }
        this.builder.setQueueName(queueName);
    }

    @Override
    public void setQueueState(QueueState queueState) {
        this.maybeInitBuilder();
        if (queueState == null) {
            this.builder.clearState();
            return;
        }
        this.builder.setState(this.convertToProtoFormat(queueState));
    }

    public YarnProtos.QueueInfoProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((QueueInfoPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    private void initLocalApplicationsList() {
        if (this.applicationsList != null) {
            return;
        }
        YarnProtos.QueueInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ApplicationReportProto> list = p.getApplicationsList();
        this.applicationsList = new ArrayList<ApplicationReport>();
        for (YarnProtos.ApplicationReportProto a : list) {
            this.applicationsList.add(this.convertFromProtoFormat(a));
        }
    }

    private void addApplicationsToProto() {
        this.maybeInitBuilder();
        this.builder.clearApplications();
        if (this.applicationsList == null) {
            return;
        }
        Iterable<YarnProtos.ApplicationReportProto> iterable = new Iterable<YarnProtos.ApplicationReportProto>(){

            @Override
            public Iterator<YarnProtos.ApplicationReportProto> iterator() {
                return new Iterator<YarnProtos.ApplicationReportProto>(){
                    Iterator<ApplicationReport> iter;
                    {
                        this.iter = QueueInfoPBImpl.this.applicationsList.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ApplicationReportProto next() {
                        return QueueInfoPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllApplications((Iterable<? extends YarnProtos.ApplicationReportProto>)iterable);
    }

    private void initLocalChildQueuesList() {
        if (this.childQueuesList != null) {
            return;
        }
        YarnProtos.QueueInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.QueueInfoProto> list = p.getChildQueuesList();
        this.childQueuesList = new ArrayList<QueueInfo>();
        for (YarnProtos.QueueInfoProto a : list) {
            this.childQueuesList.add(this.convertFromProtoFormat(a));
        }
    }

    private void addChildQueuesInfoToProto() {
        this.maybeInitBuilder();
        this.builder.clearChildQueues();
        if (this.childQueuesList == null) {
            return;
        }
        Iterable<YarnProtos.QueueInfoProto> iterable = new Iterable<YarnProtos.QueueInfoProto>(){

            @Override
            public Iterator<YarnProtos.QueueInfoProto> iterator() {
                return new Iterator<YarnProtos.QueueInfoProto>(){
                    Iterator<QueueInfo> iter;
                    {
                        this.iter = QueueInfoPBImpl.this.childQueuesList.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.QueueInfoProto next() {
                        return QueueInfoPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllChildQueues((Iterable<? extends YarnProtos.QueueInfoProto>)iterable);
    }

    private void mergeLocalToBuilder() {
        if (this.childQueuesList != null) {
            this.addChildQueuesInfoToProto();
        }
        if (this.applicationsList != null) {
            this.addApplicationsToProto();
        }
        if (this.accessibleNodeLabels != null) {
            this.builder.clearAccessibleNodeLabels();
            this.builder.addAllAccessibleNodeLabels(this.accessibleNodeLabels);
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.QueueInfoProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private ApplicationReportPBImpl convertFromProtoFormat(YarnProtos.ApplicationReportProto a) {
        return new ApplicationReportPBImpl(a);
    }

    private YarnProtos.ApplicationReportProto convertToProtoFormat(ApplicationReport t) {
        return ((ApplicationReportPBImpl)t).getProto();
    }

    private QueueInfoPBImpl convertFromProtoFormat(YarnProtos.QueueInfoProto a) {
        return new QueueInfoPBImpl(a);
    }

    private YarnProtos.QueueInfoProto convertToProtoFormat(QueueInfo q) {
        return ((QueueInfoPBImpl)q).getProto();
    }

    private QueueState convertFromProtoFormat(YarnProtos.QueueStateProto q) {
        return ProtoUtils.convertFromProtoFormat(q);
    }

    private YarnProtos.QueueStateProto convertToProtoFormat(QueueState queueState) {
        return ProtoUtils.convertToProtoFormat(queueState);
    }

    @Override
    public void setAccessibleNodeLabels(Set<String> nodeLabels) {
        this.maybeInitBuilder();
        this.builder.clearAccessibleNodeLabels();
        this.accessibleNodeLabels = nodeLabels;
    }

    private void initNodeLabels() {
        if (this.accessibleNodeLabels != null) {
            return;
        }
        YarnProtos.QueueInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        this.accessibleNodeLabels = new HashSet<String>();
        this.accessibleNodeLabels.addAll(p.getAccessibleNodeLabelsList());
    }

    @Override
    public Set<String> getAccessibleNodeLabels() {
        this.initNodeLabels();
        return this.accessibleNodeLabels;
    }

    @Override
    public String getDefaultNodeLabelExpression() {
        YarnProtos.QueueInfoProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasDefaultNodeLabelExpression() ? p.getDefaultNodeLabelExpression().trim() : null;
    }

    @Override
    public void setDefaultNodeLabelExpression(String defaultNodeLabelExpression) {
        this.maybeInitBuilder();
        if (defaultNodeLabelExpression == null) {
            this.builder.clearDefaultNodeLabelExpression();
            return;
        }
        this.builder.setDefaultNodeLabelExpression(defaultNodeLabelExpression);
    }
}

