/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class Times {
    private static final Log LOG = LogFactory.getLog(Times.class);
    static final ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy");
        }
    };

    public static long elapsed(long started, long finished) {
        return Times.elapsed(started, finished, true);
    }

    public static long elapsed(long started, long finished, boolean isRunning) {
        if (finished > 0L && started > 0L) {
            long elapsed = finished - started;
            if (elapsed >= 0L) {
                return elapsed;
            }
            LOG.warn("Finished time " + finished + " is ahead of started time " + started);
            return -1L;
        }
        if (isRunning) {
            long elapsed;
            long current = System.currentTimeMillis();
            long l = elapsed = started > 0L ? current - started : 0L;
            if (elapsed >= 0L) {
                return elapsed;
            }
            LOG.warn("Current time " + current + " is ahead of started time " + started);
            return -1L;
        }
        return -1L;
    }

    public static String format(long ts) {
        return ts > 0L ? String.valueOf(dateFormat.get().format(new Date(ts))) : "N/A";
    }
}

