/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RetriableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtils {
    public static final Logger LOG = LoggerFactory.getLogger(RetryUtils.class);

    public static RetryPolicy getDefaultRetryPolicy(Configuration conf, String retryPolicyEnabledKey, boolean defaultRetryPolicyEnabled, String retryPolicySpecKey, String defaultRetryPolicySpec, String remoteExceptionToRetry) {
        RetryPolicy multipleLinearRandomRetry = RetryUtils.getMultipleLinearRandomRetry(conf, retryPolicyEnabledKey, defaultRetryPolicyEnabled, retryPolicySpecKey, defaultRetryPolicySpec);
        LOG.debug("multipleLinearRandomRetry = {}", (Object)multipleLinearRandomRetry);
        if (multipleLinearRandomRetry == null) {
            return RetryPolicies.TRY_ONCE_THEN_FAIL;
        }
        return new WrapperRetryPolicy((RetryPolicies.MultipleLinearRandomRetry)multipleLinearRandomRetry, remoteExceptionToRetry);
    }

    public static RetryPolicy getMultipleLinearRandomRetry(Configuration conf, String retryPolicyEnabledKey, boolean defaultRetryPolicyEnabled, String retryPolicySpecKey, String defaultRetryPolicySpec) {
        boolean enabled = conf.getBoolean(retryPolicyEnabledKey, defaultRetryPolicyEnabled);
        if (!enabled) {
            return null;
        }
        String policy = conf.get(retryPolicySpecKey, defaultRetryPolicySpec);
        RetryPolicies.MultipleLinearRandomRetry r = RetryPolicies.MultipleLinearRandomRetry.parseCommaSeparatedString(policy);
        return r != null ? r : RetryPolicies.MultipleLinearRandomRetry.parseCommaSeparatedString(defaultRetryPolicySpec);
    }

    private static final class WrapperRetryPolicy
    implements RetryPolicy {
        private RetryPolicies.MultipleLinearRandomRetry multipleLinearRandomRetry;
        private String remoteExceptionToRetry;

        private WrapperRetryPolicy(RetryPolicies.MultipleLinearRandomRetry multipleLinearRandomRetry, String remoteExceptionToRetry) {
            this.multipleLinearRandomRetry = multipleLinearRandomRetry;
            this.remoteExceptionToRetry = remoteExceptionToRetry;
        }

        @Override
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isMethodIdempotent) throws Exception {
            RemoteException re;
            Throwable cause;
            if (e instanceof ServiceException && (cause = e.getCause()) != null && cause instanceof Exception) {
                e = (Exception)cause;
            }
            RetryPolicy p = e instanceof RetriableException || RetryPolicies.getWrappedRetriableException(e) != null ? this.multipleLinearRandomRetry : (e instanceof RemoteException ? ((re = (RemoteException)e).getClassName().equals(this.remoteExceptionToRetry) ? this.multipleLinearRandomRetry : RetryPolicies.TRY_ONCE_THEN_FAIL) : (e instanceof IOException || e instanceof ServiceException ? this.multipleLinearRandomRetry : RetryPolicies.TRY_ONCE_THEN_FAIL));
            LOG.debug("RETRY {}) policy={}", retries, p.getClass().getSimpleName(), e);
            return p.shouldRetry(e, retries, failovers, isMethodIdempotent);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof WrapperRetryPolicy && this.multipleLinearRandomRetry.equals(((WrapperRetryPolicy)obj).multipleLinearRandomRetry);
        }

        public int hashCode() {
            return this.multipleLinearRandomRetry.hashCode();
        }

        public String toString() {
            return "RetryPolicy[" + this.multipleLinearRandomRetry + ", " + RetryPolicies.TRY_ONCE_THEN_FAIL.getClass().getSimpleName() + "]";
        }
    }
}

