/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricType;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsTag;

public class PrometheusMetricsSink
implements MetricsSink {
    private final Map<String, String> metricLines = new ConcurrentHashMap<String, String>();
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!(^|[A-Z_]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
    private static final Pattern DELIMITERS = Pattern.compile("[^a-zA-Z0-9]+");

    @Override
    public void putMetrics(MetricsRecord metricsRecord) {
        for (AbstractMetric metrics : metricsRecord.metrics()) {
            if (metrics.type() != MetricType.COUNTER && metrics.type() != MetricType.GAUGE) continue;
            String key = this.prometheusName(metricsRecord.name(), metrics.name());
            StringBuilder builder = new StringBuilder();
            builder.append("# TYPE ").append(key).append(" ").append(metrics.type().toString().toLowerCase()).append("\n").append(key).append("{");
            String sep = "";
            for (MetricsTag tag : metricsRecord.tags()) {
                String tagName = tag.name().toLowerCase();
                if (tagName.equals("numopenconnectionsperuser")) continue;
                builder.append(sep).append(tagName).append("=\"").append(tag.value()).append("\"");
                sep = ",";
            }
            builder.append("} ");
            builder.append(metrics.value());
            builder.append("\n");
            this.metricLines.put(key, builder.toString());
        }
    }

    public String prometheusName(String recordName, String metricName) {
        String baseName = StringUtils.capitalize(recordName) + StringUtils.capitalize(metricName);
        CharSequence[] parts = SPLIT_PATTERN.split(baseName);
        String joined = String.join((CharSequence)"_", parts).toLowerCase();
        return DELIMITERS.matcher(joined).replaceAll("_");
    }

    @Override
    public void flush() {
    }

    @Override
    public void init(SubsetConfiguration subsetConfiguration) {
    }

    public void writeMetrics(Writer writer) throws IOException {
        for (String line : this.metricLines.values()) {
            writer.write(line);
        }
    }
}

