/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.text.MessageFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.FileMonitoringTimerTask;
import org.apache.hadoop.security.ssl.KeyStoresFactory;
import org.apache.hadoop.security.ssl.ReloadingX509KeystoreManager;
import org.apache.hadoop.security.ssl.ReloadingX509TrustManager;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FileBasedKeyStoresFactory
implements KeyStoresFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedKeyStoresFactory.class);
    public static final String SSL_MONITORING_THREAD_NAME = "SSL Certificates Store Monitor";
    public static final String SSL_STORES_RELOAD_INTERVAL_TPL_KEY = "ssl.{0}.stores.reload.interval";
    public static final String SSL_KEYSTORE_LOCATION_TPL_KEY = "ssl.{0}.keystore.location";
    public static final String SSL_KEYSTORE_PASSWORD_TPL_KEY = "ssl.{0}.keystore.password";
    public static final String SSL_KEYSTORE_KEYPASSWORD_TPL_KEY = "ssl.{0}.keystore.keypassword";
    public static final String SSL_KEYSTORE_TYPE_TPL_KEY = "ssl.{0}.keystore.type";
    public static final String SSL_TRUSTSTORE_RELOAD_INTERVAL_TPL_KEY = "ssl.{0}.truststore.reload.interval";
    public static final String SSL_TRUSTSTORE_LOCATION_TPL_KEY = "ssl.{0}.truststore.location";
    public static final String SSL_TRUSTSTORE_PASSWORD_TPL_KEY = "ssl.{0}.truststore.password";
    public static final String SSL_TRUSTSTORE_TYPE_TPL_KEY = "ssl.{0}.truststore.type";
    public static final String SSL_EXCLUDE_CIPHER_LIST = "ssl.{0}.exclude.cipher.list";
    public static final String DEFAULT_KEYSTORE_TYPE = "jks";
    public static final int DEFAULT_SSL_STORES_RELOAD_INTERVAL = 10000;
    private Configuration conf;
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    private ReloadingX509TrustManager trustManager;
    private Timer fileMonitoringTimer;

    private void createTrustManagersFromConfiguration(SSLFactory.Mode mode, String truststoreType, String truststoreLocation, long storesReloadInterval) throws IOException, GeneralSecurityException {
        String passwordProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_PASSWORD_TPL_KEY);
        String truststorePassword = this.getPassword(this.conf, passwordProperty, "");
        if (truststorePassword.isEmpty()) {
            truststorePassword = null;
        }
        long truststoreReloadInterval = this.conf.getLong(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_RELOAD_INTERVAL_TPL_KEY), storesReloadInterval);
        if (LOG.isDebugEnabled()) {
            LOG.debug(mode.toString() + " TrustStore: " + truststoreLocation + ", reloading at " + truststoreReloadInterval + " millis.");
        }
        this.trustManager = new ReloadingX509TrustManager(truststoreType, truststoreLocation, truststorePassword);
        if (truststoreReloadInterval > 0L) {
            this.fileMonitoringTimer.schedule((TimerTask)new FileMonitoringTimerTask(Paths.get(truststoreLocation, new String[0]), path -> this.trustManager.loadFrom((Path)path), exception -> LOG.error("Could not load truststore (keep using existing one) : ", (Throwable)exception)), truststoreReloadInterval, truststoreReloadInterval);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(mode.toString() + " Loaded TrustStore: " + truststoreLocation);
        }
        this.trustManagers = new TrustManager[]{this.trustManager};
    }

    private void createKeyManagersFromConfiguration(SSLFactory.Mode mode, String keystoreType, long storesReloadInterval) throws GeneralSecurityException, IOException {
        String locationProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_LOCATION_TPL_KEY);
        String keystoreLocation = this.conf.get(locationProperty, "");
        if (keystoreLocation.isEmpty()) {
            throw new GeneralSecurityException("The property '" + locationProperty + "' has not been set in the ssl configuration file.");
        }
        String passwordProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_PASSWORD_TPL_KEY);
        String keystorePassword = this.getPassword(this.conf, passwordProperty, "");
        if (keystorePassword.isEmpty()) {
            throw new GeneralSecurityException("The property '" + passwordProperty + "' has not been set in the ssl configuration file.");
        }
        String keyPasswordProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_KEYPASSWORD_TPL_KEY);
        String keystoreKeyPassword = this.getPassword(this.conf, keyPasswordProperty, keystorePassword);
        if (LOG.isDebugEnabled()) {
            LOG.debug(mode.toString() + " KeyStore: " + keystoreLocation);
        }
        ReloadingX509KeystoreManager keystoreManager = new ReloadingX509KeystoreManager(keystoreType, keystoreLocation, keystorePassword, keystoreKeyPassword);
        if (storesReloadInterval > 0L) {
            this.fileMonitoringTimer.schedule((TimerTask)new FileMonitoringTimerTask(Paths.get(keystoreLocation, new String[0]), path -> keystoreManager.loadFrom((Path)path), exception -> LOG.error("Could not load keystore (keep using existing one) : ", (Throwable)exception)), storesReloadInterval, storesReloadInterval);
        }
        this.keyManagers = new KeyManager[]{keystoreManager};
    }

    @VisibleForTesting
    public static String resolvePropertyName(SSLFactory.Mode mode, String template) {
        return MessageFormat.format(template, StringUtils.toLowerCase(mode.toString()));
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void init(SSLFactory.Mode mode) throws IOException, GeneralSecurityException {
        boolean requireClientCert = this.conf.getBoolean("hadoop.ssl.require.client.cert", false);
        long storesReloadInterval = this.conf.getLong(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_STORES_RELOAD_INTERVAL_TPL_KEY), 10000L);
        this.fileMonitoringTimer = new Timer(SSL_MONITORING_THREAD_NAME, true);
        String keystoreType = this.conf.get(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_TYPE_TPL_KEY), DEFAULT_KEYSTORE_TYPE);
        if (requireClientCert || mode == SSLFactory.Mode.SERVER) {
            this.createKeyManagersFromConfiguration(mode, keystoreType, storesReloadInterval);
        } else {
            KeyStore keystore = KeyStore.getInstance(keystoreType);
            keystore.load(null, null);
            KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance(SSLFactory.SSLCERTIFICATE);
            keyMgrFactory.init(keystore, null);
            this.keyManagers = keyMgrFactory.getKeyManagers();
        }
        String truststoreType = this.conf.get(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_TYPE_TPL_KEY), DEFAULT_KEYSTORE_TYPE);
        String locationProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_LOCATION_TPL_KEY);
        String truststoreLocation = this.conf.get(locationProperty, "");
        if (!truststoreLocation.isEmpty()) {
            this.createTrustManagersFromConfiguration(mode, truststoreType, truststoreLocation, storesReloadInterval);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The property '" + locationProperty + "' has not been set, no TrustStore will be loaded");
            }
            this.trustManagers = null;
        }
    }

    String getPassword(Configuration conf, String alias, String defaultPass) {
        String password = defaultPass;
        try {
            char[] passchars = conf.getPassword(alias);
            if (passchars != null) {
                password = new String(passchars);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Exception while trying to get password for alias " + alias + ": " + ioe.getMessage());
        }
        return password;
    }

    @Override
    public synchronized void destroy() {
        if (this.trustManager != null) {
            this.fileMonitoringTimer.cancel();
            this.trustManager = null;
            this.keyManagers = null;
            this.trustManagers = null;
        }
    }

    @Override
    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    @Override
    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }
}

