/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.namenode.BlocksMap;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

class INodeFileUnderConstruction
extends INodeFile {
    final String clientName;
    private final String clientMachine;
    private final DatanodeDescriptor clientNode;
    private int primaryNodeIndex = -1;
    private DatanodeDescriptor[] targets = null;
    private long lastRecoveryTime = 0L;

    INodeFileUnderConstruction(PermissionStatus permissions, short replication, long preferredBlockSize, long modTime, String clientName, String clientMachine, DatanodeDescriptor clientNode) {
        super(permissions.applyUMask(UMASK), 0, replication, modTime, modTime, preferredBlockSize);
        this.clientName = clientName;
        this.clientMachine = clientMachine;
        this.clientNode = clientNode;
    }

    public INodeFileUnderConstruction(byte[] name, short blockReplication, long modificationTime, long preferredBlockSize, BlocksMap.BlockInfo[] blocks, PermissionStatus perm, String clientName, String clientMachine, DatanodeDescriptor clientNode) {
        super(perm, blocks, blockReplication, modificationTime, modificationTime, preferredBlockSize);
        this.setLocalName(name);
        this.clientName = clientName;
        this.clientMachine = clientMachine;
        this.clientNode = clientNode;
    }

    String getClientName() {
        return this.clientName;
    }

    String getClientMachine() {
        return this.clientMachine;
    }

    DatanodeDescriptor getClientNode() {
        return this.clientNode;
    }

    @Override
    boolean isUnderConstruction() {
        return true;
    }

    DatanodeDescriptor[] getTargets() {
        return this.targets;
    }

    void setTargets(DatanodeDescriptor[] targets) {
        this.targets = targets;
        this.primaryNodeIndex = -1;
    }

    INodeFile convertToInodeFile() {
        INodeFile obj = new INodeFile(this.getPermissionStatus(), this.getBlocks(), this.getReplication(), this.getModificationTime(), this.getModificationTime(), this.getPreferredBlockSize());
        return obj;
    }

    void removeBlock(Block oldblock) throws IOException {
        if (this.blocks == null) {
            throw new IOException("Trying to delete non-existant block " + oldblock);
        }
        int size_1 = this.blocks.length - 1;
        if (!this.blocks[size_1].equals(oldblock)) {
            throw new IOException("Trying to delete non-last block " + oldblock);
        }
        BlocksMap.BlockInfo[] newlist = new BlocksMap.BlockInfo[size_1];
        System.arraycopy(this.blocks, 0, newlist, 0, size_1);
        this.blocks = newlist;
        this.targets = null;
    }

    synchronized void setLastBlock(BlocksMap.BlockInfo newblock, DatanodeDescriptor[] newtargets) throws IOException {
        if (this.blocks == null) {
            throw new IOException("Trying to update non-existant block (newblock=" + newblock + ")");
        }
        this.blocks[this.blocks.length - 1] = newblock;
        this.setTargets(newtargets);
        this.lastRecoveryTime = 0L;
    }

    void assignPrimaryDatanode() {
        if (this.targets.length == 0) {
            NameNode.stateChangeLog.warn((Object)"BLOCK* INodeFileUnderConstruction.initLeaseRecovery: No blocks found, lease removed.");
        }
        int previous = this.primaryNodeIndex;
        for (int i = 1; i <= this.targets.length; ++i) {
            int j = (previous + i) % this.targets.length;
            if (!this.targets[j].isAlive) continue;
            this.primaryNodeIndex = j;
            DatanodeDescriptor primary = this.targets[this.primaryNodeIndex];
            primary.addBlockToBeRecovered(this.blocks[this.blocks.length - 1], this.targets);
            NameNode.stateChangeLog.info((Object)("BLOCK* " + this.blocks[this.blocks.length - 1] + " recovery started, primary=" + primary));
            return;
        }
    }

    synchronized boolean setLastRecoveryTime(long now) {
        boolean expired;
        boolean bl = expired = now - this.lastRecoveryTime > 10000L;
        if (expired) {
            this.lastRecoveryTime = now;
        }
        return expired;
    }
}

