/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.specific;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.ipc.generic.GenericResponder;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;

public class SpecificResponder
extends GenericResponder {
    private Object impl;
    private SpecificData data;

    public SpecificResponder(Class iface, Object impl) {
        this(SpecificData.get().getProtocol(iface), impl);
    }

    public SpecificResponder(Protocol protocol, Object impl) {
        this(protocol, impl, SpecificData.get());
    }

    protected SpecificResponder(Protocol protocol, Object impl, SpecificData data) {
        super(protocol);
        this.impl = impl;
        this.data = data;
    }

    @Override
    protected DatumWriter<Object> getDatumWriter(Schema schema) {
        return new SpecificDatumWriter<Object>(schema);
    }

    @Override
    protected DatumReader<Object> getDatumReader(Schema actual, Schema expected) {
        return new SpecificDatumReader<Object>(actual, expected);
    }

    @Override
    public void writeError(Schema schema, Object error, Encoder out) throws IOException {
        this.getDatumWriter(schema).write(error, out);
    }

    @Override
    public Object respond(Protocol.Message message, Object request) throws Exception {
        int numParams = message.getRequest().getFields().size();
        Object[] params = new Object[numParams];
        Class[] paramTypes = new Class[numParams];
        int i = 0;
        try {
            for (Schema.Field param : message.getRequest().getFields()) {
                params[i] = ((GenericRecord)request).get(param.name());
                paramTypes[i] = this.data.getClass(param.schema());
                ++i;
            }
            Method method = this.impl.getClass().getMethod(message.getName(), paramTypes);
            method.setAccessible(true);
            return method.invoke(this.impl, params);
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getTargetException();
        }
        catch (NoSuchMethodException e) {
            throw new AvroRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new AvroRuntimeException(e);
        }
    }
}

