/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class AvroOutputFormat<T>
extends FileOutputFormat<AvroWrapper<T>, NullWritable> {
    public static final String EXT = ".avro";
    public static final String DEFLATE_LEVEL_KEY = "avro.mapred.deflate.level";
    public static final String SYNC_INTERVAL_KEY = "avro.mapred.sync.interval";
    public static final int DEFAULT_DEFLATE_LEVEL = 1;

    public static void setDeflateLevel(JobConf job, int level) {
        FileOutputFormat.setCompressOutput(job, true);
        job.setInt(DEFLATE_LEVEL_KEY, level);
    }

    public static void setSyncInterval(JobConf job, int syncIntervalInBytes) {
        job.setInt(SYNC_INTERVAL_KEY, syncIntervalInBytes);
    }

    static <T> void configureDataFileWriter(DataFileWriter<T> writer, JobConf job) throws UnsupportedEncodingException {
        if (FileOutputFormat.getCompressOutput(job)) {
            int level = job.getInt(DEFLATE_LEVEL_KEY, 1);
            String codecName = job.get("avro.output.codec", "deflate");
            CodecFactory factory = codecName.equals("deflate") ? CodecFactory.deflateCodec(level) : CodecFactory.fromString(codecName);
            writer.setCodec(factory);
        }
        writer.setSyncInterval(job.getInt(SYNC_INTERVAL_KEY, 16000));
        for (Map.Entry<String, String> e : job) {
            if (e.getKey().startsWith("avro.meta.text.")) {
                writer.setMeta(e.getKey().substring("avro.meta.text.".length()), e.getValue());
            }
            if (!e.getKey().startsWith("avro.meta.binary.")) continue;
            writer.setMeta(e.getKey().substring("avro.meta.binary.".length()), URLDecoder.decode(e.getValue(), "ISO-8859-1").getBytes("ISO-8859-1"));
        }
    }

    @Override
    public RecordWriter<AvroWrapper<T>, NullWritable> getRecordWriter(FileSystem ignore, JobConf job, String name, Progressable prog) throws IOException {
        boolean isMapOnly = job.getNumReduceTasks() == 0;
        Schema schema = isMapOnly ? AvroJob.getMapOutputSchema(job) : AvroJob.getOutputSchema(job);
        final DataFileWriter writer = new DataFileWriter(new ReflectDatumWriter());
        AvroOutputFormat.configureDataFileWriter(writer, job);
        Path path = FileOutputFormat.getTaskOutputPath(job, name + EXT);
        writer.create(schema, path.getFileSystem(job).create(path));
        return new RecordWriter<AvroWrapper<T>, NullWritable>(){

            @Override
            public void write(AvroWrapper<T> wrapper, NullWritable ignore) throws IOException {
                writer.append(wrapper.datum());
            }

            @Override
            public void close(Reporter reporter) throws IOException {
                writer.close();
            }
        };
    }
}

