/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.tool.Tool;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;

public class BinaryFragmentToJsonTool
implements Tool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        boolean needsClosing;
        InputStream input;
        if (args.size() != 2) {
            err.println("Expected 1 arguments: schema binary_data_file");
            err.println("Use '-' as binary_data_file for stdin.");
            return 1;
        }
        Schema schema = Schema.parse(args.get(0));
        if (args.get(1).equals("-")) {
            input = stdin;
            needsClosing = false;
        } else {
            input = new FileInputStream(args.get(1));
            needsClosing = true;
        }
        try {
            GenericDatumReader<Object> reader = new GenericDatumReader<Object>(schema);
            Object datum = reader.read(null, DecoderFactory.get().binaryDecoder(input, null));
            GenericDatumWriter<Object> writer = new GenericDatumWriter<Object>(schema);
            JsonGenerator g = new JsonFactory().createJsonGenerator(out, JsonEncoding.UTF8);
            g.useDefaultPrettyPrinter();
            writer.write(datum, EncoderFactory.get().jsonEncoder(schema, g));
            g.flush();
            out.println();
            out.flush();
        }
        finally {
            if (needsClosing) {
                input.close();
            }
        }
        return 0;
    }

    @Override
    public String getName() {
        return "fragtojson";
    }

    @Override
    public String getShortDescription() {
        return "Renders a binary-encoded Avro datum as JSON.";
    }
}

