/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.avro.Schema;
import org.apache.avro.mapred.tether.TetherJob;
import org.apache.avro.tool.Tool;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;

public class TetherTool
implements Tool {
    public TetherJob job;

    @Override
    public String getName() {
        return "tether";
    }

    @Override
    public String getShortDescription() {
        return "Run a tethered mapreduce job.";
    }

    @Override
    public int run(InputStream ins, PrintStream outs, PrintStream err, List<String> args) throws Exception {
        OptionParser p = new OptionParser();
        ArgumentAcceptingOptionSpec<URI> exec = p.accepts("program", "executable program, usually in HDFS").withRequiredArg().ofType(URI.class);
        ArgumentAcceptingOptionSpec<String> in = p.accepts("in", "comma-separated input paths").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<Path> out = p.accepts("out", "output directory").withRequiredArg().ofType(Path.class);
        ArgumentAcceptingOptionSpec<File> outSchema = p.accepts("outschema", "output schema file").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> mapOutSchema = p.accepts("outschemamap", "map output schema file, if different").withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<Integer> reduces = p.accepts("reduces", "number of reduces").withOptionalArg().ofType(Integer.class);
        JobConf job = new JobConf();
        try {
            OptionSet opts = p.parse(args.toArray(new String[0]));
            FileInputFormat.addInputPaths(job, (String)in.value(opts));
            FileOutputFormat.setOutputPath(job, (Path)out.value(opts));
            TetherJob.setExecutable(job, (URI)exec.value(opts));
            job.set("avro.output.schema", Schema.parse((File)outSchema.value(opts)).toString());
            if (opts.hasArgument(mapOutSchema)) {
                job.set("avro.map.output.schema", Schema.parse((File)mapOutSchema.value(opts)).toString());
            }
            if (opts.hasArgument(reduces)) {
                job.setNumReduceTasks((Integer)reduces.value(opts));
            }
        }
        catch (Exception e) {
            p.printHelpOn(err);
            return -1;
        }
        TetherJob.runJob(job);
        return 0;
    }
}

