/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;

public class FromTextTool
implements Tool {
    private static final String TEXT_FILE_SCHEMA = "\"bytes\"";

    @Override
    public String getName() {
        return "fromtext";
    }

    @Override
    public String getShortDescription() {
        return "Imports a text file into an avro data file.";
    }

    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser p = new OptionParser();
        ArgumentAcceptingOptionSpec<Integer> level = p.accepts("level", "compression level").withOptionalArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec<String> codec = p.accepts("codec", "compression codec").withOptionalArg().ofType(String.class);
        OptionSet opts = p.parse(args.toArray(new String[0]));
        List<String> nargs = opts.nonOptionArguments();
        if (nargs.size() != 2) {
            err.println("Expected 2 args: from_file to_file (local filenames, Hadoop URI's, or '-' for stdin/stdout");
            p.printHelpOn(err);
            return 1;
        }
        int compressionLevel = 1;
        if (opts.hasArgument(level)) {
            compressionLevel = (Integer)level.value(opts);
        }
        String codecName = opts.hasArgument(codec) ? (String)codec.value(opts) : "deflate";
        CodecFactory codecFactory = codecName.equals("deflate") ? CodecFactory.deflateCodec(compressionLevel) : CodecFactory.fromString(codecName);
        BufferedInputStream inStream = Util.fileOrStdin(nargs.get(0), stdin);
        BufferedOutputStream outStream = Util.fileOrStdout(nargs.get(1), out);
        DataFileWriter<ByteBuffer> writer = new DataFileWriter<ByteBuffer>(new GenericDatumWriter());
        writer.setCodec(codecFactory);
        writer.create(Schema.parse(TEXT_FILE_SCHEMA), outStream);
        ByteBuffer line = ByteBuffer.allocate(128);
        boolean returnSeen = false;
        byte[] buf = new byte[8192];
        int end = inStream.read(buf);
        while (end != -1) {
            for (int i = 0; i < end; ++i) {
                int b = buf[i] & 0xFF;
                if (b == 10) {
                    if (!returnSeen) {
                        System.out.println("Writing line = " + line.position());
                        line.flip();
                        writer.append(line);
                        line.clear();
                        continue;
                    }
                    returnSeen = false;
                    continue;
                }
                if (b == 13) {
                    line.flip();
                    writer.append(line);
                    line.clear();
                    returnSeen = true;
                    continue;
                }
                if (line.position() == line.limit()) {
                    ByteBuffer tempLine = ByteBuffer.allocate(line.limit() * 2);
                    line.flip();
                    tempLine.put(line);
                    line = tempLine;
                }
                line.put((byte)b);
                returnSeen = false;
            }
            end = inStream.read(buf);
        }
        writer.close();
        inStream.close();
        return 0;
    }
}

