/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.tool.Tool;

public class SpecificCompilerTool
implements Tool {
    private static final FileExtensionFilter SCHEMA_FILTER = new FileExtensionFilter("avsc");
    private static final FileExtensionFilter PROTOCOL_FILTER = new FileExtensionFilter("avpr");

    @Override
    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        if (args.size() < 3) {
            System.err.println("Need at least 3 arguments: (schema|protocol) input... outputdir");
            System.err.println(" input - input files or directories");
            System.err.println(" outputdir - directory to write generated java");
            return 1;
        }
        String method = args.get(0);
        ArrayList<File> inputs = new ArrayList<File>();
        File output = new File(args.get(args.size() - 1));
        for (int i = 1; i < args.size() - 1; ++i) {
            inputs.add(new File(args.get(i)));
        }
        if ("schema".equals(method)) {
            SpecificCompiler.compileSchema(SpecificCompilerTool.determineInputs(inputs, SCHEMA_FILTER), output);
        } else if ("protocol".equals(method)) {
            SpecificCompiler.compileProtocol(SpecificCompilerTool.determineInputs(inputs, PROTOCOL_FILTER), output);
        } else {
            System.err.println("Expected \"schema\" or \"protocol\".");
            return 1;
        }
        return 0;
    }

    @Override
    public String getName() {
        return "compile";
    }

    @Override
    public String getShortDescription() {
        return "Generates Java code for the given schema.";
    }

    private static File[] determineInputs(List<File> inputs, FilenameFilter filter) {
        LinkedHashSet<File> fileSet = new LinkedHashSet<File>();
        for (File file : inputs) {
            if (file.isDirectory()) {
                for (File f : file.listFiles(filter)) {
                    fileSet.add(f);
                }
                continue;
            }
            fileSet.add(file);
        }
        if (fileSet.size() > 0) {
            System.err.println("Input files to compile:");
            for (File file : fileSet) {
                System.err.println("  " + file);
            }
        } else {
            System.err.println("No input files found.");
        }
        return fileSet.toArray(new File[fileSet.size()]);
    }

    private static class FileExtensionFilter
    implements FilenameFilter {
        private String extension;

        private FileExtensionFilter(String extension) {
            this.extension = extension;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(this.extension);
        }
    }
}

