/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyRecordWriter;
import org.apache.avro.mapreduce.AvroOutputFormatBase;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class AvroKeyOutputFormat<T>
extends AvroOutputFormatBase<AvroKey<T>, NullWritable> {
    private final RecordWriterFactory mRecordWriterFactory;

    public AvroKeyOutputFormat() {
        this(new RecordWriterFactory());
    }

    protected AvroKeyOutputFormat(RecordWriterFactory recordWriterFactory) {
        this.mRecordWriterFactory = recordWriterFactory;
    }

    @Override
    public RecordWriter<AvroKey<T>, NullWritable> getRecordWriter(TaskAttemptContext context) throws IOException {
        Schema writerSchema = AvroJob.getOutputKeySchema(context.getConfiguration());
        if (null == writerSchema) {
            throw new IOException("AvroKeyOutputFormat requires an output schema. Use AvroJob.setOutputKeySchema().");
        }
        return this.mRecordWriterFactory.create(writerSchema, AvroKeyOutputFormat.getCompressionCodec(context), this.getAvroFileOutputStream(context));
    }

    protected static class RecordWriterFactory<T> {
        protected RecordWriterFactory() {
        }

        protected RecordWriter<AvroKey<T>, NullWritable> create(Schema writerSchema, CodecFactory compressionCodec, OutputStream outputStream) throws IOException {
            return new AvroKeyRecordWriter(writerSchema, compressionCodec, outputStream);
        }
    }
}

