/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.tool.Tool;

public class RecodecTool
implements Tool {
    @Override
    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser optParser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> codecOpt = optParser.accepts("codec", "Compression codec").withRequiredArg().defaultsTo("null", (String[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec<String> levelOpt = optParser.accepts("level", "Compression level (only applies to deflate)").withRequiredArg().defaultsTo("-1", (String[])new String[0]).ofType(String.class);
        OptionSet opts = optParser.parse(args.toArray(new String[0]));
        List<String> nargs = opts.nonOptionArguments();
        if (nargs.size() > 2) {
            err.println("Expected at most an input file and output file.");
            optParser.printHelpOn(err);
            return 1;
        }
        InputStream input = in;
        boolean inputNeedsClosing = false;
        if (nargs.size() > 0 && !nargs.get(0).equals("-")) {
            input = new FileInputStream(nargs.get(0));
            inputNeedsClosing = true;
        }
        OutputStream output = out;
        boolean outputNeedsClosing = false;
        if (nargs.size() > 1 && !nargs.get(1).equals("-")) {
            output = new FileOutputStream(nargs.get(1));
            outputNeedsClosing = true;
        }
        DataFileStream reader = new DataFileStream(input, new GenericDatumReader());
        Schema schema = reader.getSchema();
        DataFileWriter writer = new DataFileWriter(new GenericDatumWriter());
        CodecFactory codec = opts.valueOf(codecOpt).equals("deflate") ? CodecFactory.deflateCodec(Integer.parseInt((String)levelOpt.value(opts))) : CodecFactory.fromString((String)codecOpt.value(opts));
        writer.setCodec(codec);
        for (String key : reader.getMetaKeys()) {
            if (DataFileWriter.isReservedMeta(key)) continue;
            writer.setMeta(key, reader.getMeta(key));
        }
        writer.create(schema, output);
        writer.appendAllFrom(reader, true);
        writer.flush();
        if (inputNeedsClosing) {
            input.close();
        }
        if (outputNeedsClosing) {
            output.close();
        }
        return 0;
    }

    @Override
    public String getName() {
        return "recodec";
    }

    @Override
    public String getShortDescription() {
        return "Alters the codec of a data file.";
    }
}

